/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.quickstart;

import com.googlecode.mobilityrpc.MobilityRPC;
import com.googlecode.mobilityrpc.controller.MobilityController;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.quickstart.util.NetworkUtil;
import java.util.List;

public class EmbeddedMobilityServer {
    public static final int DEFAULT_PORT = 5739;
    private static volatile MobilityController instance = null;
    private static volatile List<String> addresses = null;

    public static synchronized MobilityController start() {
        MobilityController mobilityController = instance;
        if (mobilityController != null) {
            throw new IllegalStateException("Server is already running");
        }
        mobilityController = MobilityRPC.newController();
        List<String> bindAddresses = NetworkUtil.getAllNetworkInterfaceAddresses();
        for (String networkAddress : bindAddresses) {
            mobilityController.getConnectionManager().bindConnectionListener(new ConnectionId(networkAddress, 5739));
        }
        instance = mobilityController;
        addresses = bindAddresses;
        return mobilityController;
    }

    public static synchronized void stop() {
        MobilityController mobilityController = instance;
        if (mobilityController != null) {
            mobilityController.destroy();
            instance = null;
        }
    }

    public static MobilityController getMobilityController() {
        MobilityController mobilityController = instance;
        if (mobilityController == null) {
            throw new IllegalStateException("Server has not been started");
        }
        return mobilityController;
    }

    static List<String> getAddresses() {
        List<String> addresses = EmbeddedMobilityServer.addresses;
        if (addresses == null) {
            throw new IllegalStateException("Server has not been started");
        }
        return addresses;
    }
}

