/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.serialization.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ObjectBuffer;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.serialize.ReferenceFieldSerializer;
import com.googlecode.mobilityrpc.serialization.Serializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.ClassSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.CurrencySerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.StringBufferSerializer;
import de.javakaffee.kryoserializers.StringBuilderSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import org.objenesis.ObjenesisStd;

public class KryoSerializer
implements Serializer {
    private final ClassLoader classLoader;
    private final Kryo kryo;
    private final int INITIAL_BUFFER_SIZE_IN_BYTES = 32768;
    private final int MAX_BUFFER_SIZE_IN_BYTES = 0x6400000;
    private final int MAX_CACHEABLE_BUFFER_SIZE_IN_BYTES = 65536;
    private final ThreadLocal<ObjectBuffer> threadLocalObjectBuffers = new ThreadLocal<ObjectBuffer>(){

        @Override
        protected ObjectBuffer initialValue() {
            return new ObjectBuffer(KryoSerializer.this.kryo, 32768, 0x6400000);
        }
    };

    public KryoSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
        final ObjenesisStd objenesisStd = new ObjenesisStd();
        this.kryo = new Kryo(){

            protected com.esotericsoftware.kryo.Serializer newDefaultSerializer(Class aClass) {
                return new ReferenceFieldSerializer(this, aClass){
                    {
                        this.setIgnoreSyntheticFields(false);
                    }

                    public <T> T newInstance(Kryo kryo, Class<T> tClass) {
                        try {
                            return tClass.cast(objenesisStd.newInstance(tClass));
                        }
                        catch (Exception e) {
                            throw new SerializationException("Could not instantiate class using JVM-specific strategy: " + tClass.getName(), (Throwable)e);
                        }
                    }
                };
            }
        };
        this.kryo.setRegistrationOptional(true);
        this.kryo.setClassLoader(classLoader);
        this.kryo.register(Arrays.asList("").getClass(), (com.esotericsoftware.kryo.Serializer)new ArraysAsListSerializer(this.kryo));
        this.kryo.register(Class.class, (com.esotericsoftware.kryo.Serializer)new ClassSerializer(this.kryo));
        this.kryo.register(Collections.EMPTY_LIST.getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsEmptyListSerializer());
        this.kryo.register(Collections.EMPTY_MAP.getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsEmptyMapSerializer());
        this.kryo.register(Collections.EMPTY_SET.getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsEmptySetSerializer());
        this.kryo.register(Collections.singletonList("").getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsSingletonListSerializer(this.kryo));
        this.kryo.register(Collections.singleton("").getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsSingletonSetSerializer(this.kryo));
        this.kryo.register(Collections.singletonMap("", "").getClass(), (com.esotericsoftware.kryo.Serializer)new CollectionsSingletonMapSerializer(this.kryo));
        this.kryo.register(Currency.class, (com.esotericsoftware.kryo.Serializer)new CurrencySerializer(this.kryo));
        this.kryo.register(GregorianCalendar.class, (com.esotericsoftware.kryo.Serializer)new GregorianCalendarSerializer());
        this.kryo.register(InvocationHandler.class, (com.esotericsoftware.kryo.Serializer)new JdkProxySerializer(this.kryo));
        this.kryo.register(StringBuffer.class, (com.esotericsoftware.kryo.Serializer)new StringBufferSerializer(this.kryo));
        this.kryo.register(StringBuilder.class, (com.esotericsoftware.kryo.Serializer)new StringBuilderSerializer(this.kryo));
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)this.kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)this.kryo);
    }

    @Override
    public byte[] serialize(Object object) {
        ObjectBuffer buffer = this.threadLocalObjectBuffers.get();
        byte[] result = buffer.writeClassAndObject(object);
        if (result.length > 65536) {
            this.threadLocalObjectBuffers.remove();
        }
        return result;
    }

    @Override
    public Object deserialize(byte[] serializedData) {
        ObjectBuffer buffer = this.threadLocalObjectBuffers.get();
        if (serializedData.length > 65536) {
            this.threadLocalObjectBuffers.remove();
        }
        return buffer.readClassAndObject(serializedData);
    }
}

