/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Context;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compressor
extends Serializer {
    private Serializer serializer;
    private boolean compress = true;
    private boolean decompress = true;
    protected final int bufferSize;

    public Compressor(Serializer serializer) {
        this(serializer, 2048);
    }

    public Compressor(Serializer serializer, int bufferSize) {
        this.serializer = serializer;
        this.bufferSize = bufferSize;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        if (!this.compress) {
            this.serializer.writeObjectData(buffer, object);
            return;
        }
        int start = buffer.position() + 2;
        try {
            buffer.position(start);
        }
        catch (IllegalArgumentException ex) {
            new BufferOverflowException();
        }
        this.serializer.writeObjectData(buffer, object);
        int end = buffer.position();
        buffer.position(start);
        buffer.limit(end);
        Context context = Kryo.getContext();
        ByteBuffer outputBuffer = context.getBuffer(this.bufferSize);
        this.compress(buffer, object, outputBuffer);
        outputBuffer.flip();
        buffer.position(start - 2);
        buffer.limit(buffer.capacity());
        buffer.putShort((short)outputBuffer.limit());
        buffer.put(outputBuffer);
        if (Log.TRACE) {
            Log.trace("kryo", "Compressed to " + (float)((int)((float)outputBuffer.limit() / (float)(end - start) * 10000.0f)) / 100.0f + "% using: " + this.getClass().getName());
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        if (!this.decompress) {
            return this.serializer.readObjectData(buffer, type);
        }
        int oldLimit = buffer.limit();
        short length = buffer.getShort();
        try {
            buffer.limit(buffer.position() + length);
        }
        catch (IllegalArgumentException ex) {
            throw new SerializationException("Compressed data length exceeds buffer capacity: " + buffer.position() + length, ex);
        }
        Context context = Kryo.getContext();
        ByteBuffer outputBuffer = context.getBuffer(this.bufferSize);
        this.decompress(buffer, type, outputBuffer);
        outputBuffer.flip();
        buffer.limit(oldLimit);
        if (Log.TRACE) {
            Log.trace("kryo", "Decompressed using: " + this.getClass().getName());
        }
        return this.serializer.readObjectData(outputBuffer, type);
    }

    public abstract void compress(ByteBuffer var1, Object var2, ByteBuffer var3);

    public abstract void decompress(ByteBuffer var1, Class var2, ByteBuffer var3);
}

