/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Context;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.CustomSerialization;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.DefaultSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.ArraySerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.BooleanSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.ByteSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.CharSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.CollectionSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.CustomSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.DoubleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.FieldSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.FloatSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.LongSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.MapSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.ShortSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.StringSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.util.IntHashMap;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kryo {
    public static final String version = "1.03";
    private static final byte ID_NULL_OBJECT = 0;
    private static final int ID_CLASS_NAME = 16383;
    private static ThreadLocal<Context> contextThreadLocal = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };
    private final ConcurrentHashMap<Integer, RegisteredClass> idToRegisteredClass = new ConcurrentHashMap(64);
    private final ConcurrentHashMap<Class, RegisteredClass> classToRegisteredClass = new ConcurrentHashMap(64);
    private AtomicInteger nextClassID = new AtomicInteger(1);
    private Object listenerLock = new Object();
    private volatile Listener[] listeners = new Listener[0];
    private boolean registrationOptional;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private final CustomSerializer customSerializer = new CustomSerializer(this);
    private final ArraySerializer arraySerializer = new ArraySerializer(this);
    private final CollectionSerializer collectionSerializer = new CollectionSerializer(this);
    private final MapSerializer mapSerializer = new MapSerializer(this);

    public Kryo() {
        this.register(Boolean.TYPE, new BooleanSerializer());
        this.register(Byte.TYPE, new ByteSerializer());
        this.register(Character.TYPE, new CharSerializer());
        this.register(Short.TYPE, new ShortSerializer());
        this.register(Integer.TYPE, new IntSerializer());
        this.register(Long.TYPE, new LongSerializer());
        this.register(Float.TYPE, new FloatSerializer());
        this.register(Double.TYPE, new DoubleSerializer());
        this.register(Boolean.class, new BooleanSerializer());
        this.register(Byte.class, new ByteSerializer());
        this.register(Character.class, new CharSerializer());
        this.register(Short.class, new ShortSerializer());
        this.register(Integer.class, new IntSerializer());
        this.register(Long.class, new LongSerializer());
        this.register(Float.class, new FloatSerializer());
        this.register(Double.class, new DoubleSerializer());
        this.register(String.class, new StringSerializer());
    }

    public void setRegistrationOptional(boolean registrationOptional) {
        this.registrationOptional = registrationOptional;
    }

    public RegisteredClass register(Class type, Serializer serializer, boolean useClassNameString) {
        int id;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        if (type.isPrimitive()) {
            serializer.setCanBeNull(false);
        }
        RegisteredClass existingRegisteredClass = this.classToRegisteredClass.get(type);
        if (useClassNameString) {
            id = 16383;
        } else if (existingRegisteredClass != null) {
            id = existingRegisteredClass.id;
        } else {
            id = this.nextClassID.getAndIncrement();
            if (id == 16383) {
                id = this.nextClassID.getAndIncrement();
            }
        }
        RegisteredClass registeredClass = new RegisteredClass(type, id, serializer);
        if (!useClassNameString) {
            this.idToRegisteredClass.put(id, registeredClass);
        }
        this.classToRegisteredClass.put(type, registeredClass);
        if (Log.TRACE && id > 17) {
            String name = type.getName();
            if (type.isArray()) {
                Class elementClass = ArraySerializer.getElementClass(type);
                StringBuilder buffer = new StringBuilder(16);
                int n = ArraySerializer.getDimensionCount(type);
                for (int i = 0; i < n; ++i) {
                    buffer.append("[]");
                }
                name = elementClass.getName() + buffer;
            }
            if (useClassNameString) {
                Log.trace("kryo", "Registered class name: " + name + " (" + serializer.getClass().getName() + ")");
            } else {
                Log.trace("kryo", "Registered class ID " + id + ": " + name + " (" + serializer.getClass().getName() + ")");
            }
        }
        return registeredClass;
    }

    public RegisteredClass register(Class type, Serializer serializer) {
        return this.register(type, serializer, false);
    }

    public RegisteredClass register(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        RegisteredClass existingRegisteredClass = this.classToRegisteredClass.get(type);
        if (existingRegisteredClass != null && existingRegisteredClass.id >= 1 && existingRegisteredClass.id <= 17) {
            throw new IllegalArgumentException("Class is registered by default: " + type.getName());
        }
        return this.register(type, this.newSerializer(type));
    }

    public void register(Class type, RegisteredClass registeredClass) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (registeredClass == null) {
            throw new IllegalArgumentException("registeredClass cannot be null.");
        }
        this.classToRegisteredClass.put(type, registeredClass);
        if (Log.TRACE) {
            String name = type.getName();
            if (type.isArray()) {
                Class elementClass = ArraySerializer.getElementClass(type);
                StringBuilder buffer = new StringBuilder(16);
                int n = ArraySerializer.getDimensionCount(type);
                for (int i = 0; i < n; ++i) {
                    buffer.append("[]");
                }
                name = elementClass.getName() + buffer;
            }
            if (registeredClass.id == 16383) {
                Log.trace("kryo", "Registered class name: " + name + " (" + registeredClass.serializer.getClass().getName() + ")");
            } else {
                Log.trace("kryo", "Registered class ID " + registeredClass.id + ": " + name + " (" + registeredClass.serializer.getClass().getName() + ")");
            }
        }
    }

    public Serializer newSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type.isArray()) {
            return this.arraySerializer;
        }
        if (CustomSerialization.class.isAssignableFrom(type)) {
            return this.customSerializer;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.collectionSerializer;
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.mapSerializer;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumSerializer(type);
        }
        if (type.isAnnotationPresent(DefaultSerializer.class)) {
            Class<? extends Serializer> serializerClass = type.getAnnotation(DefaultSerializer.class).value();
            try {
                try {
                    return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(this, type);
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        return serializerClass.getConstructor(Kryo.class).newInstance(this);
                    }
                    catch (NoSuchMethodException ex2) {
                        try {
                            return serializerClass.getConstructor(Class.class).newInstance(this, type);
                        }
                        catch (NoSuchMethodException ex3) {
                            return serializerClass.newInstance();
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + type.getName(), ex);
            }
        }
        return this.newDefaultSerializer(type);
    }

    protected Serializer newDefaultSerializer(Class type) {
        return new FieldSerializer(this, type);
    }

    public RegisteredClass getRegisteredClass(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        RegisteredClass registeredClass = this.classToRegisteredClass.get(type);
        if (registeredClass != null) {
            return registeredClass;
        }
        if (Proxy.isProxyClass(type)) {
            return this.getRegisteredClass(InvocationHandler.class);
        }
        if (!type.isEnum() && Enum.class.isAssignableFrom(type) && (registeredClass = this.classToRegisteredClass.get(type = type.getEnclosingClass())) != null) {
            return registeredClass;
        }
        if (this.registrationOptional) {
            this.handleUnregisteredClass(type);
            registeredClass = this.classToRegisteredClass.get(type);
            if (registeredClass != null) {
                return registeredClass;
            }
        }
        if (type.isArray()) {
            Class elementClass = ArraySerializer.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n = ArraySerializer.getDimensionCount(type);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            throw new IllegalArgumentException("Class is not registered: " + type.getName() + "\nNote: To register this class use: kryo.register(" + elementClass.getName() + buffer + ".class);");
        }
        throw new IllegalArgumentException("Class is not registered: " + type.getName());
    }

    protected void handleUnregisteredClass(Class type) {
        this.register(type, this.newSerializer(type), true);
    }

    public RegisteredClass getRegisteredClass(int classID) {
        RegisteredClass registeredClass = this.idToRegisteredClass.get(classID);
        if (registeredClass == null) {
            throw new IllegalArgumentException("Class ID is not registered: " + classID);
        }
        return registeredClass;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Serializer getSerializer(Class type) {
        return this.getRegisteredClass((Class)type).serializer;
    }

    public void setSerializer(Class type, Serializer serializer) {
        this.getRegisteredClass((Class)type).serializer = serializer;
    }

    public RegisteredClass writeClass(ByteBuffer buffer, Class type) {
        if (type == null) {
            try {
                buffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return null;
            }
            catch (BufferOverflowException ex) {
                throw new SerializationException("Buffer limit exceeded writing null object.", ex);
            }
        }
        try {
            RegisteredClass registeredClass = this.getRegisteredClass(type);
            IntSerializer.put(buffer, registeredClass.id, true);
            if (registeredClass.id == 16383) {
                Integer reference;
                Context context = Kryo.getContext();
                ClassReferences references = (ClassReferences)context.getTemp("classReferences");
                if (references == null) {
                    references = (ClassReferences)context.get("classReferences");
                    if (references == null) {
                        references = new ClassReferences();
                        context.put("classReferences", references);
                    } else {
                        references.reset();
                    }
                    context.putTemp("classReferences", references);
                }
                if ((reference = references.classToReference.get(type)) != null) {
                    IntSerializer.put(buffer, reference, true);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Wrote class name reference " + reference + ": " + type.getName());
                    }
                    return registeredClass;
                }
                buffer.put((byte)0);
                references.classToReference.put(type, references.referenceCount++);
                StringSerializer.put(buffer, type.getName());
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote class name: " + type.getName());
                }
            } else if (Log.TRACE) {
                Log.trace("kryo", "Wrote class " + registeredClass.id + ": " + type.getName());
            }
            return registeredClass;
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing class ID: " + type, ex);
            }
            throw ex;
        }
        catch (BufferOverflowException ex) {
            throw new SerializationException("Buffer limit exceeded writing class ID: " + type, ex);
        }
    }

    public RegisteredClass readClass(ByteBuffer buffer) {
        int classID;
        block18: {
            try {
                Class<?> type;
                int reference;
                classID = IntSerializer.get(buffer, true);
                if (classID == 0) {
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read object: null");
                    }
                    return null;
                }
                if (classID != 16383) break block18;
                Context context = Kryo.getContext();
                ClassReferences references = (ClassReferences)context.getTemp("classReferences");
                if (references == null) {
                    references = (ClassReferences)context.get("classReferences");
                    if (references == null) {
                        references = new ClassReferences();
                        context.put("classReferences", references);
                    } else {
                        references.reset();
                    }
                    context.putTemp("classReferences", references);
                }
                if ((reference = IntSerializer.get(buffer, true)) != 0) {
                    type = (Class<?>)references.referenceToClass.get(reference);
                    if (type == null) {
                        throw new SerializationException("Invalid class name reference: " + reference);
                    }
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read class name reference " + reference + ": " + type.getName());
                    }
                } else {
                    String className = StringSerializer.get(buffer);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read class name: " + className);
                    }
                    try {
                        type = Class.forName(className, false, this.classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new SerializationException("Unable to find class: " + className, ex);
                    }
                    references.referenceToClass.put(references.referenceCount++, type);
                }
                return this.getRegisteredClass(type);
            }
            catch (SerializationException ex) {
                if (ex.causedBy(BufferUnderflowException.class)) {
                    throw new SerializationException("Buffer limit exceeded reading class ID.", ex);
                }
                throw ex;
            }
            catch (BufferUnderflowException ex) {
                throw new SerializationException("Buffer limit exceeded reading class ID.", ex);
            }
        }
        RegisteredClass registeredClass = this.idToRegisteredClass.get(classID);
        if (registeredClass == null) {
            throw new SerializationException("Encountered unregistered class ID: " + classID);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + classID + ": " + registeredClass.type.getName());
        }
        return registeredClass;
    }

    public void writeClassAndObject(ByteBuffer buffer, Object object) {
        if (object == null) {
            try {
                buffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return;
            }
            catch (BufferOverflowException ex) {
                throw new SerializationException("Buffer limit exceeded writing null object.", ex);
            }
        }
        RegisteredClass registeredClass = this.writeClass(buffer, object.getClass());
        if (registeredClass == null) {
            return;
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            registeredClass.serializer.writeObjectData(buffer, object);
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public void writeObject(ByteBuffer buffer, Object object) {
        if (object == null) {
            try {
                buffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return;
            }
            catch (BufferOverflowException ex) {
                throw new SerializationException("Buffer limit exceeded writing null object.", ex);
            }
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            this.getRegisteredClass(object.getClass()).serializer.writeObject(buffer, object);
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            this.getRegisteredClass(object.getClass()).serializer.writeObjectData(buffer, object);
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public Object readClassAndObject(ByteBuffer buffer) {
        RegisteredClass registeredClass = this.readClass(buffer);
        if (registeredClass == null) {
            return null;
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            Object t = registeredClass.serializer.readObjectData(buffer, registeredClass.type);
            return t;
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + registeredClass.type.getName(), ex);
            }
            throw new SerializationException("Unable to deserialize object of type: " + registeredClass.type.getName(), ex);
        }
        catch (BufferUnderflowException ex) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + registeredClass.type.getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public <T> T readObject(ByteBuffer buffer, Class<T> type) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            T t = this.getRegisteredClass(type).serializer.readObject(buffer, type);
            return t;
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + type.getName(), ex);
            }
            throw new SerializationException("Unable to deserialize object of type: " + type.getName(), ex);
        }
        catch (BufferUnderflowException ex) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + type.getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            T t = this.getRegisteredClass(type).serializer.readObjectData(buffer, type);
            return t;
        }
        catch (SerializationException ex) {
            if (ex.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + type.getName(), ex);
            }
            throw new SerializationException("Unable to deserialize object of type: " + type.getName(), ex);
        }
        catch (BufferUnderflowException ex) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + type.getName(), ex);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listeners[i]) continue;
                return;
            }
            Listener[] newListeners = new Listener[n + 1];
            newListeners[0] = listener;
            System.arraycopy(listeners, 0, newListeners, 1, n);
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Kryo listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n = listeners.length;
            if (n == 0) {
                return;
            }
            Listener[] newListeners = new Listener[n - 1];
            int ii = 0;
            for (int i = 0; i < n; ++i) {
                if (listener == listeners[i]) continue;
                if (ii == n - 1) {
                    return;
                }
                newListeners[ii++] = listener;
            }
            System.arraycopy(listeners, 0, newListeners, 1, n);
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Kryo listener removed: " + listener.getClass().getName());
        }
    }

    public void removeRemoteEntity(int remoteEntityID) {
        Listener[] listeners = this.listeners;
        if (Log.TRACE) {
            Log.trace("kryo", "Remote ID removed: " + remoteEntityID);
        }
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            listeners[i].remoteEntityRemoved(remoteEntityID);
        }
    }

    public <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            try {
                Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException ignored) {
            }
            catch (NoSuchMethodException ignored) {
                if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                    throw new SerializationException("Class cannot be created (non-static member class): " + type.getName(), ex);
                }
                throw new SerializationException("Class cannot be created (missing no-arg constructor): " + type.getName(), ex);
            }
            catch (Exception privateConstructorException) {
                ex = privateConstructorException;
            }
            throw new SerializationException("Error constructing instance of class: " + type.getName(), ex);
        }
    }

    public static boolean isFinal(Class type) {
        if (type.isArray()) {
            return Modifier.isFinal(ArraySerializer.getElementClass(type).getModifiers());
        }
        return Modifier.isFinal(type.getModifiers());
    }

    public static Context getContext() {
        return contextThreadLocal.get();
    }

    static class ClassReferences {
        public HashMap<Class, Integer> classToReference = new HashMap();
        public IntHashMap referenceToClass = new IntHashMap();
        public int referenceCount = 1;

        ClassReferences() {
        }

        public void reset() {
            this.classToReference.clear();
            this.referenceToClass.clear();
            this.referenceCount = 1;
        }
    }

    public static interface Listener {
        public void remoteEntityRemoved(int var1);
    }

    public static class RegisteredClass {
        final Class type;
        final int id;
        Serializer serializer;

        RegisteredClass(Class type, int id, Serializer serializer) {
            this.type = type;
            this.id = id;
            this.serializer = serializer;
        }

        public Class getType() {
            return this.type;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public int getID() {
            return this.id;
        }
    }
}

