/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class ByteSerializer
extends Serializer {
    public Byte readObjectData(ByteBuffer buffer, Class type) {
        byte b = buffer.get();
        if (Log.TRACE) {
            Log.trace("kryo", "Read byte: " + b);
        }
        return b;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        buffer.put((Byte)object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote byte: " + object);
        }
    }

    public static void putUnsigned(ByteBuffer buffer, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value cannot be less than zero: " + value);
        }
        buffer.put((byte)value);
    }

    public static int getUnsigned(ByteBuffer buffer) {
        byte value = buffer.get();
        if (value < 0) {
            return value + 256;
        }
        return value;
    }
}

