/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.LongSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class DoubleSerializer
extends Serializer {
    private final double precision;
    private final boolean optimizePositive;

    public DoubleSerializer() {
        this.precision = 0.0;
        this.optimizePositive = false;
    }

    public DoubleSerializer(double precision, boolean optimizePositive) {
        this.precision = precision;
        this.optimizePositive = optimizePositive;
    }

    public Double readObjectData(ByteBuffer buffer, Class type) {
        double d = this.precision == 0.0 ? buffer.getDouble() : (double)LongSerializer.get(buffer, this.optimizePositive) / this.precision;
        if (Log.TRACE) {
            Log.trace("kryo", "Read double: " + d);
        }
        return d;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        if (this.precision == 0.0) {
            buffer.putDouble((Double)object);
        } else {
            LongSerializer.put(buffer, (long)((Double)object * this.precision), this.optimizePositive);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote double: " + object);
        }
    }
}

