/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class StringSerializer
extends Serializer {
    public String readObjectData(ByteBuffer buffer, Class type) {
        String s = StringSerializer.get(buffer);
        if (Log.TRACE) {
            Log.trace("kryo", "Read string: " + s);
        }
        return s;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        String s = (String)object;
        StringSerializer.put(buffer, s);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote string: " + object);
        }
    }

    public static void put(ByteBuffer buffer, String value) {
        int charCount = value.length();
        IntSerializer.put(buffer, charCount, true);
        for (int i = 0; i < charCount; ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f') {
                buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static String get(ByteBuffer buffer) {
        int charCount = IntSerializer.get(buffer, true);
        char[] chars = Kryo.getContext().getCharArray(charCount);
        int charIndex = 0;
        while (charIndex < charCount) {
            int c = buffer.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | buffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (buffer.get() & 0x3F) << 6 | (buffer.get() & 0x3F) << 0);
                }
            }
        }
        return new String(chars, 0, charCount);
    }
}

