/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.util;

public class LongToIntHashMap {
    private Entry[] table;
    private float loadFactor;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    public LongToIntHashMap() {
        this(16, 0.75f);
    }

    public LongToIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongToIntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(int value) {
        Entry[] table = this.table;
        int i = table.length;
        while (i-- > 0) {
            Entry e = table[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        int index = (int)key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int get(long key) {
        int index = (int)key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public int put(long key, int value) {
        int index = (int)key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                int oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.table[index] = new Entry(key, value, this.table[index]);
        if (this.size++ >= this.threshold) {
            int newCapacity = 2 * this.capacity;
            Entry[] newTable = new Entry[newCapacity];
            Entry[] src = this.table;
            int bucketmask = newCapacity - 1;
            for (int j = 0; j < src.length; ++j) {
                Entry next;
                Entry e2 = src[j];
                if (e2 == null) continue;
                src[j] = null;
                do {
                    next = e2.next;
                    index = (int)e2.key & bucketmask;
                    e2.next = newTable[index];
                    newTable[index] = e2;
                } while ((e2 = next) != null);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return 0;
    }

    public int remove(long key) {
        Entry prev;
        int index = (int)key & this.mask;
        Entry e = prev = this.table[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] table = this.table;
        int index = table.length;
        while (--index >= 0) {
            table[index] = null;
        }
        this.size = 0;
    }

    static class Entry {
        final long key;
        int value;
        Entry next;

        Entry(long k, int v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }
    }
}

