/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.LongSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.StringSerializer;
import com.googlecode.mobilityrpc.lib.org.joda.time.Chronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.DateTime;
import com.googlecode.mobilityrpc.lib.org.joda.time.DateTimeZone;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.BuddhistChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.CopticChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.EthiopicChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.GJChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.GregorianChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.ISOChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.IslamicChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.chrono.JulianChronology;
import java.nio.ByteBuffer;

public class JodaDateTimeSerializer
extends SimpleSerializer<DateTime> {
    static final String MILLIS = "millis";
    static final String DATE_TIME = "dt";
    static final String CHRONOLOGY = "ch";
    static final String TIME_ZONE = "tz";

    @Override
    public DateTime read(ByteBuffer buffer) {
        long millis = LongSerializer.get(buffer, true);
        Chronology chronology = this.readChronology(buffer);
        DateTimeZone tz = this.readTimeZone(buffer);
        return new DateTime(millis, chronology.withZone(tz));
    }

    private Chronology readChronology(ByteBuffer buffer) {
        String chronologyId = StringSerializer.get(buffer);
        return IdentifiableChronology.valueOfId("".equals(chronologyId) ? null : chronologyId);
    }

    private DateTimeZone readTimeZone(ByteBuffer buffer) {
        String tz = StringSerializer.get(buffer);
        return "".equals(tz) ? DateTimeZone.getDefault() : DateTimeZone.forID((String)tz.toString());
    }

    @Override
    public void write(ByteBuffer buffer, DateTime obj) {
        LongSerializer.put(buffer, obj.getMillis(), true);
        String chronologyId = this.getChronologyId(obj.getChronology());
        StringSerializer.put(buffer, chronologyId == null ? "" : chronologyId);
        if (obj.getZone() != null && obj.getZone() != DateTimeZone.getDefault()) {
            StringSerializer.put(buffer, obj.getZone().getID());
        } else {
            StringSerializer.put(buffer, "");
        }
    }

    private String getChronologyId(Chronology chronology) {
        return IdentifiableChronology.getIdByChronology(chronology.getClass());
    }

    static enum IdentifiableChronology {
        ISO(null, (Chronology)ISOChronology.getInstance()),
        COPTIC("COPTIC", (Chronology)CopticChronology.getInstance()),
        ETHIOPIC("ETHIOPIC", (Chronology)EthiopicChronology.getInstance()),
        GREGORIAN("GREGORIAN", (Chronology)GregorianChronology.getInstance()),
        JULIAN("JULIAN", (Chronology)JulianChronology.getInstance()),
        ISLAMIC("ISLAMIC", (Chronology)IslamicChronology.getInstance()),
        BUDDHIST("BUDDHIST", (Chronology)BuddhistChronology.getInstance()),
        GJ("GJ", (Chronology)GJChronology.getInstance());

        private final String _id;
        private final Chronology _chronology;

        private IdentifiableChronology(String id, Chronology chronology) {
            this._id = id;
            this._chronology = chronology;
        }

        public String getId() {
            return this._id;
        }

        public static String getIdByChronology(Class<? extends Chronology> clazz) throws IllegalArgumentException {
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!clazz.equals(item._chronology.getClass())) continue;
                return item._id;
            }
            throw new IllegalArgumentException("Chronology not supported: " + clazz.getSimpleName());
        }

        public static Chronology valueOfId(String id) throws IllegalArgumentException {
            if (id == null) {
                return IdentifiableChronology.ISO._chronology;
            }
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!id.equals(item._id)) continue;
                return item._chronology;
            }
            throw new IllegalArgumentException("No chronology found for id " + id);
        }
    }
}

