/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.wicket;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import com.googlecode.mobilityrpc.lib.org.apache.wicket.util.collections.MiniMap;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Map;

public class MiniMapSerializer
extends SimpleSerializer<MiniMap<?, ?>> {
    private static final Field KEYS_FIELD;
    private final Kryo _kryo;

    public MiniMapSerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    @Override
    public MiniMap<?, ?> read(ByteBuffer buffer) {
        int maxEntries = IntSerializer.get(buffer, true);
        MiniMap result = new MiniMap(maxEntries);
        int size = IntSerializer.get(buffer, true);
        for (int i = 0; i < size; ++i) {
            Object key = this._kryo.readClassAndObject(buffer);
            Object value = this._kryo.readClassAndObject(buffer);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void write(ByteBuffer buffer, MiniMap<?, ?> map) {
        IntSerializer.put(buffer, this.getMaxEntries(map), true);
        IntSerializer.put(buffer, map.size(), true);
        for (Map.Entry entry : map.entrySet()) {
            this._kryo.writeClassAndObject(buffer, entry.getKey());
            this._kryo.writeClassAndObject(buffer, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote map: " + map);
        }
    }

    private int getMaxEntries(MiniMap<?, ?> map) {
        try {
            return ((Object[])KEYS_FIELD.get(map)).length;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            KEYS_FIELD = MiniMap.class.getDeclaredField("keys");
            KEYS_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The MiniMap seems to have changed, could not access expected field.", e);
        }
    }
}

