/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.processors.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.Connection;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.ConnectionManager;
import com.googlecode.mobilityrpc.protocol.converters.messages.EnvelopeMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.PongMessageConverter;
import com.googlecode.mobilityrpc.protocol.pojo.Envelope;
import com.googlecode.mobilityrpc.protocol.pojo.Ping;
import com.googlecode.mobilityrpc.protocol.pojo.Pong;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PingMessageProcessor
implements DeserializedMessageProcessor<Ping> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final EnvelopeMessageConverter envelopeMessageConverter = new EnvelopeMessageConverter();
    private final PongMessageConverter pongMessageConverter = new PongMessageConverter();

    @Override
    public void process(MobilityControllerInternal mobilityController, ConnectionManager connectionManager, ConnectionId connectionId, Ping ping) {
        Pong pong = new Pong(ping.getRequestId(), "PONG! " + ping.getMessage());
        byte[] pongMessage = this.pongMessageConverter.convertToProtobuf(pong);
        byte[] replyEnvelope = this.envelopeMessageConverter.convertToProtobuf(new Envelope(Envelope.MessageType.PONG, pongMessage));
        Connection connection = connectionManager.getConnection(connectionId);
        connection.enqueueOutgoingMessage(replyEnvelope);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Received and replied to Ping message from connection '" + connectionId + "': " + ping);
        }
    }
}

