/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.quickstart;

import com.googlecode.mobilityrpc.quickstart.EmbeddedMobilityServer;
import com.googlecode.mobilityrpc.quickstart.util.LoggingUtil;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.UIManager;

public class StandaloneMobilityServer {
    public static void main(String[] args) {
        LoggingUtil.setLibraryLoggingLevel(Boolean.getBoolean("debug") ? Level.FINER : Level.INFO);
        LoggingUtil.setSingleLineLoggingFormat();
        EmbeddedMobilityServer.start();
        System.out.println("Mobility-RPC Server started, listening on port 5739 on the following addresses:");
        for (String networkAddress : EmbeddedMobilityServer.getAddresses()) {
            System.out.println(networkAddress);
        }
        System.out.println();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EmbeddedMobilityServer.stop();
                System.out.println("\nMobility-RPC Server stopped");
            }
        });
        StandaloneMobilityServer.addSystemTrayIconIfSupported();
    }

    static void addSystemTrayIconIfSupported() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Mobility-RPC");
        if (!GraphicsEnvironment.isHeadless() && SystemTray.isSupported() && !Boolean.getBoolean("com.googlecode.mobilityrpc.headless")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        final StringBuilder infoMessage = new StringBuilder();
                        infoMessage.append("Mobility-RPC Standalone Server is running.\n\n");
                        infoMessage.append("Listening on port ").append(5739).append(" on the following addresses:\n");
                        for (String networkAddress : EmbeddedMobilityServer.getAddresses()) {
                            infoMessage.append(networkAddress).append("\n");
                        }
                        infoMessage.append("\nTo shut down Mobility-RPC, select the Exit option from this menu.");
                        String uiResourceName = "OptionPane.informationIcon";
                        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
                        if (icon == null) {
                            throw new IllegalStateException("Unable to load graphic for system tray icon using resource name: OptionPane.informationIcon");
                        }
                        int w = icon.getIconWidth();
                        int h = icon.getIconHeight();
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gd = ge.getDefaultScreenDevice();
                        GraphicsConfiguration gc = gd.getDefaultConfiguration();
                        BufferedImage image = gc.createCompatibleImage(w, h, 3);
                        Graphics2D g = image.createGraphics();
                        icon.paintIcon(null, g, 0, 0);
                        g.dispose();
                        BufferedImage graphic = image;
                        PopupMenu popup = new PopupMenu();
                        MenuItem exitItem = new MenuItem("Exit Mobility-RPC");
                        popup.add(exitItem);
                        final TrayIcon trayIcon = new TrayIcon(graphic, "Mobility-RPC Standalone Server is running", popup);
                        trayIcon.setImageAutoSize(true);
                        trayIcon.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                trayIcon.displayMessage("Mobility-RPC Running", infoMessage.toString(), TrayIcon.MessageType.INFO);
                            }
                        });
                        exitItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                System.exit(0);
                            }
                        });
                        SystemTray.getSystemTray().add(trayIcon);
                        trayIcon.displayMessage("Mobility-RPC Running", infoMessage.toString(), TrayIcon.MessageType.INFO);
                    }
                    catch (Exception e) {
                        System.err.println("Exception adding system tray icon");
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

