/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.session.impl;

import com.googlecode.mobilityrpc.controller.MobilityController;
import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionMode;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionResponse;
import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import com.googlecode.mobilityrpc.protocol.pojo.SerializationFormat;
import com.googlecode.mobilityrpc.serialization.Serializer;
import com.googlecode.mobilityrpc.serialization.impl.KryoSerializer;
import com.googlecode.mobilityrpc.session.impl.MobilityContextInternal;
import com.googlecode.mobilityrpc.session.impl.MobilitySessionInternal;
import com.googlecode.mobilityrpc.session.impl.SessionClassLoader;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MobilitySessionImpl
implements MobilitySessionInternal {
    private static final long EXECUTION_RESPONSE_TIMEOUT_MILLIS = 60000L;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final UUID sessionId;
    private final MobilityControllerInternal mobilityController;
    private final SessionClassLoader sessionClassLoader;
    private final Serializer defaultSerializer;
    private final SerializationFormat defaultSerializationFormat;
    private final ConcurrentMap<RequestIdentifier, FutureExecutionResponse> futureExecutionResponses = new ConcurrentHashMap<RequestIdentifier, FutureExecutionResponse>();
    private final AtomicInteger numRemoteThreadsExecutingInThisSession = new AtomicInteger();
    private volatile boolean sessionReleaseRequested = false;

    public MobilitySessionImpl(UUID sessionId, MobilityControllerInternal mobilityController) {
        this.sessionId = sessionId;
        this.mobilityController = mobilityController;
        this.sessionClassLoader = new SessionClassLoader(mobilityController, sessionId);
        this.defaultSerializer = new KryoSerializer(this.sessionClassLoader);
        this.defaultSerializationFormat = SerializationFormat.KRYO;
    }

    @Override
    public UUID getSessionId() {
        return this.sessionId;
    }

    @Override
    public void execute(String address, Runnable runnable) {
        this.execute(new ConnectionId(address, 5739), runnable);
    }

    @Override
    public void execute(ConnectionId connectionId, Runnable runnable) {
        this.execute(connectionId, ExecutionMode.RETURN_RESPONSE, runnable);
    }

    @Override
    public void execute(ConnectionId connectionId, ExecutionMode executionMode, Runnable runnable) {
        byte[] serializedExecutableObject = this.serialize(runnable, this.defaultSerializationFormat);
        RequestIdentifier requestIdentifier = new RequestIdentifier(this.sessionId, UUID.randomUUID(), null);
        ExecutionRequest outgoingRequest = new ExecutionRequest(serializedExecutableObject, this.defaultSerializationFormat, executionMode, requestIdentifier);
        switch (executionMode) {
            case FIRE_AND_FORGET: {
                try {
                    this.mobilityController.sendOutgoingMessage(connectionId, outgoingRequest);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to submit Runnable object in FIRE_AND_FORGET mode for execution on remote machine: " + connectionId, e);
                }
            }
            case RETURN_RESPONSE: {
                ExecutionResponse executionResponse;
                try {
                    FutureExecutionResponse futureExecutionResponse = new FutureExecutionResponse(requestIdentifier);
                    this.futureExecutionResponses.put(requestIdentifier, futureExecutionResponse);
                    this.mobilityController.sendOutgoingMessage(connectionId, outgoingRequest);
                    executionResponse = futureExecutionResponse.getResponse(60000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to receive response for execution request sent to remote machine in RETURN_RESPONSE mode for request identifier: " + requestIdentifier + ", connection id: " + connectionId, e);
                }
                ExecutionResponse.ExecutionOutcome executionOutcome = executionResponse.getExecutionOutcome();
                this.sessionClassLoader.setThreadLocalConnectionId(connectionId);
                try {
                    switch (executionOutcome) {
                        case VOID_RETURNED: {
                            return;
                        }
                        case FAILURE: {
                            Object responseObject = this.deserialize(executionResponse.getSerializedReturnObject(), executionResponse.getSerializationFormat());
                            if (!(responseObject instanceof Throwable)) {
                                throw new IllegalStateException("Unexpected response object returned for execution outcome FAILURE: " + responseObject);
                            }
                            throw new IllegalStateException("An exception was thrown by the Runnable object when executed on the remote machine: " + connectionId, (Throwable)responseObject);
                        }
                        case VALUE_RETURNED: {
                            throw new IllegalStateException("Unexpected ExecutionOutcome returned: " + (Object)((Object)executionMode));
                        }
                    }
                    throw new IllegalStateException("Unexpected ExecutionOutcome returned: " + (Object)((Object)executionMode));
                }
                finally {
                    this.sessionClassLoader.setThreadLocalConnectionId(null);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected ExecutionMode specified: " + (Object)((Object)executionMode));
            }
        }
    }

    @Override
    public <T> T execute(String address, Callable<T> callable) {
        return this.execute(new ConnectionId(address, 5739), callable);
    }

    @Override
    public <T> T execute(ConnectionId connectionId, Callable<T> callable) {
        return this.execute(connectionId, ExecutionMode.RETURN_RESPONSE, callable);
    }

    @Override
    public <T> T execute(ConnectionId connectionId, ExecutionMode executionMode, Callable<T> callable) {
        byte[] serializedExecutableObject = this.serialize(callable, this.defaultSerializationFormat);
        RequestIdentifier requestIdentifier = new RequestIdentifier(this.sessionId, UUID.randomUUID(), null);
        ExecutionRequest outgoingRequest = new ExecutionRequest(serializedExecutableObject, this.defaultSerializationFormat, executionMode, requestIdentifier);
        switch (executionMode) {
            case FIRE_AND_FORGET: {
                try {
                    this.mobilityController.sendOutgoingMessage(connectionId, outgoingRequest);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to submit Callable object in FIRE_AND_FORGET mode for execution on remote machine: " + connectionId, e);
                }
                return null;
            }
            case RETURN_RESPONSE: {
                ExecutionResponse executionResponse;
                try {
                    FutureExecutionResponse futureExecutionResponse = new FutureExecutionResponse(requestIdentifier);
                    this.futureExecutionResponses.put(requestIdentifier, futureExecutionResponse);
                    this.mobilityController.sendOutgoingMessage(connectionId, outgoingRequest);
                    executionResponse = futureExecutionResponse.getResponse(60000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to receive response for execution request sent to remote machine in RETURN_RESPONSE mode for request identifier: " + requestIdentifier + ", connection id: " + connectionId, e);
                }
                ExecutionResponse.ExecutionOutcome executionOutcome = executionResponse.getExecutionOutcome();
                this.sessionClassLoader.setThreadLocalConnectionId(connectionId);
                try {
                    switch (executionOutcome) {
                        case VOID_RETURNED: {
                            T t = null;
                            return t;
                        }
                        case FAILURE: {
                            Object throwable = this.deserialize(executionResponse.getSerializedReturnObject(), executionResponse.getSerializationFormat());
                            if (!(throwable instanceof Throwable)) {
                                throw new IllegalStateException("Unexpected response object returned for execution outcome FAILURE: " + throwable);
                            }
                            throw new IllegalStateException("An exception was thrown by the Callable object when executed on the remote machine: " + connectionId, (Throwable)throwable);
                        }
                        case VALUE_RETURNED: {
                            Object objectReturned;
                            Object object = objectReturned = this.deserialize(executionResponse.getSerializedReturnObject(), executionResponse.getSerializationFormat());
                            return (T)object;
                        }
                    }
                    throw new IllegalStateException("Unexpected ExecutionOutcome returned: " + (Object)((Object)executionMode));
                }
                finally {
                    this.sessionClassLoader.setThreadLocalConnectionId(null);
                }
            }
        }
        throw new IllegalStateException("Unexpected ExecutionMode specified: " + (Object)((Object)executionMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void receiveIncomingExecutionRequest(ConnectionId connectionId, ExecutionRequest executionRequest) {
        this.sessionClassLoader.setThreadLocalConnectionId(connectionId);
        try {
            this.numRemoteThreadsExecutingInThisSession.incrementAndGet();
            try {
                block24: {
                    serializeExecutableObject = executionRequest.getSerializedExecutableObject();
                    serializationFormat = executionRequest.getSerializationFormat();
                    executableObject = this.deserialize(serializeExecutableObject, serializationFormat);
                    exceptionThrown = null;
                    objectReturned = null;
                    try {
                        MobilityContextInternal.setCurrentSession(this);
                        MobilityContextInternal.setCurrentConnectionId(connectionId);
                        if (executableObject instanceof Runnable) {
                            runnable = (Runnable)executableObject;
                            runnable.run();
                            break block24;
                        }
                        if (executableObject instanceof Callable) {
                            callable = (Callable)executableObject;
                            objectReturned = callable.call();
                            break block24;
                        }
                        throw new IllegalStateException("Unexpected type of deserialized executable object, expected Runnable or Callable: " + (executableObject == null ? null : executableObject.getClass().getName()));
                    }
                    catch (Throwable e) {
                        exceptionThrown = e;
                    }
                    finally {
                        MobilityContextInternal.setCurrentSession(null);
                        MobilityContextInternal.setCurrentConnectionId(null);
                    }
                }
                switch (1.$SwitchMap$com$googlecode$mobilityrpc$protocol$pojo$ExecutionMode[executionRequest.getExecutionMode().ordinal()]) {
                    case 1: {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.log(Level.FINER, "Processed execution task and skipped sending response to client, for connection id: " + connectionId + ", execution request: " + executionRequest);
                            ** break;
                        }
lbl36:
                        // 3 sources

                        break;
                    }
                    case 2: {
                        executionResponse = objectReturned != null ? new ExecutionResponse(ExecutionResponse.ExecutionOutcome.VALUE_RETURNED, this.serialize(objectReturned, this.defaultSerializationFormat), this.defaultSerializationFormat, executionRequest.getRequestIdentifier()) : (exceptionThrown != null ? new ExecutionResponse(ExecutionResponse.ExecutionOutcome.FAILURE, this.serialize(exceptionThrown, this.defaultSerializationFormat), this.defaultSerializationFormat, executionRequest.getRequestIdentifier()) : new ExecutionResponse(ExecutionResponse.ExecutionOutcome.VOID_RETURNED, this.serialize(null, this.defaultSerializationFormat), this.defaultSerializationFormat, executionRequest.getRequestIdentifier()));
                        this.mobilityController.sendOutgoingMessage(connectionId, executionResponse);
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.log(Level.FINER, "Processed execution task and sent response to client, for connection id: " + connectionId + ", execution request: " + executionRequest);
                            ** break;
                        }
lbl43:
                        // 3 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected execution mode specified in request: " + (Object)executionRequest.getExecutionMode());
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process execution request, for connection id: " + connectionId + ", execution request: " + executionRequest, e);
            }
            finally {
                if (this.numRemoteThreadsExecutingInThisSession.decrementAndGet() == 0 && this.sessionReleaseRequested) {
                    this.doRelease();
                    this.sessionReleaseRequested = false;
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Processed deferred release of session, for connection id: " + connectionId + ", execution request: " + executionRequest);
                    }
                } else if (this.sessionReleaseRequested && this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Deferred release of session to another thread, for connection id: " + connectionId + ", execution request: " + executionRequest);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unexpected exception processing execution task, for connection id: " + connectionId + ", execution request: " + executionRequest, e);
        }
        this.sessionClassLoader.setThreadLocalConnectionId(null);
    }

    @Override
    public void receiveExecutionResponse(ExecutionResponse executionResponse) {
        RequestIdentifier requestIdentifier = executionResponse.getRequestIdentifier();
        FutureExecutionResponse futureExecutionResponse = (FutureExecutionResponse)this.futureExecutionResponses.get(requestIdentifier);
        if (futureExecutionResponse == null) {
            this.logger.log(Level.FINER, "Ignored ExecutionResponse, no pending request found, request must have timed out: {0}", executionResponse);
            return;
        }
        futureExecutionResponse.setResponse(executionResponse);
        this.logger.log(Level.FINER, "Accepted ExecutionResponse, passed to request thread: {0}", executionResponse);
    }

    @Override
    public SessionClassLoader getSessionClassLoader() {
        return this.sessionClassLoader;
    }

    @Override
    public MobilityController getMobilityController() {
        return this.mobilityController;
    }

    @Override
    public void release() {
        if (MobilityContextInternal.hasCurrentSession()) {
            this.sessionReleaseRequested = true;
        } else if (this.numRemoteThreadsExecutingInThisSession.get() == 0) {
            this.doRelease();
        } else {
            this.sessionReleaseRequested = true;
        }
    }

    void doRelease() {
        this.mobilityController.releaseSession(this.sessionId);
    }

    private Object deserialize(byte[] serializedObject, SerializationFormat serializationFormat) {
        try {
            switch (serializationFormat) {
                case KRYO: {
                    return this.defaultSerializer.deserialize(serializedObject);
                }
            }
            throw new IllegalStateException("Unsupported serialization format: " + (Object)((Object)serializationFormat));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception deserializing object from " + serializedObject.length + " bytes data in " + (Object)((Object)serializationFormat) + " format", e);
        }
    }

    private byte[] serialize(Object object, SerializationFormat serializationFormat) {
        try {
            switch (serializationFormat) {
                case KRYO: {
                    return this.defaultSerializer.serialize(object);
                }
            }
            throw new IllegalStateException("Unsupported serialization format: " + (Object)((Object)serializationFormat));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception serializing object to " + (Object)((Object)serializationFormat) + " format: " + object, e);
        }
    }

    public String toString() {
        return "MobilitySession{sessionId=" + this.sessionId + '}';
    }

    class FutureExecutionResponse {
        private final RequestIdentifier requestIdentifier;
        private final BlockingQueue<ExecutionResponse> responseQueue = new ArrayBlockingQueue<ExecutionResponse>(1);

        FutureExecutionResponse(RequestIdentifier requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        public ExecutionResponse getResponse(long timeout, TimeUnit unit) {
            try {
                ExecutionResponse executionResponse = this.responseQueue.poll(timeout, unit);
                if (executionResponse == null) {
                    throw new TimeoutException();
                }
                ExecutionResponse executionResponse2 = executionResponse;
                return executionResponse2;
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timed out waiting to receive execution response within timeout of " + timeout + " " + unit.name().toLowerCase(), e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception waiting to receive execution response", e);
            }
            finally {
                MobilitySessionImpl.this.futureExecutionResponses.remove(this.requestIdentifier);
            }
        }

        public boolean setResponse(ExecutionResponse executionResponse) {
            return this.responseQueue.add(executionResponse);
        }
    }
}

