/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    int objectGraphLevel;
    private HashMap<Object, Object> map;
    private HashMap<Object, Object> tempMap;
    private final ArrayList<ByteBuffer> buffers = new ArrayList(2);
    private int remoteEntityID;
    private final SerializerKey tempKey = new SerializerKey(null, null);
    private byte[] byteArray;
    private char[] charArray = new char[256];
    private int[] intArray;

    public ByteBuffer getBuffer(int minimumSize) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.buffers.isEmpty() ? null : this.buffers.get(0);
        if (buffer == null || buffer.capacity() < minimumSize) {
            buffer = ByteBuffer.allocate(minimumSize);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    public ArrayList<ByteBuffer> getBuffers(int count, int minimumSize) {
        int i;
        int n = Math.min(count, this.buffers.size());
        for (i = 0; i < n; ++i) {
            ByteBuffer buffer = this.buffers.get(i);
            if (buffer.capacity() >= minimumSize) continue;
            this.buffers.set(i, ByteBuffer.allocate(minimumSize));
        }
        while (i < count) {
            this.buffers.add(ByteBuffer.allocate(minimumSize));
            ++i;
        }
        return this.buffers;
    }

    public char[] getCharArray(int minimumSize) {
        if (this.charArray.length < minimumSize) {
            this.charArray = new char[minimumSize];
        }
        return this.charArray;
    }

    public int[] getIntArray(int minimumSize) {
        if (this.intArray == null || this.intArray.length < minimumSize) {
            this.intArray = new int[minimumSize];
        }
        return this.intArray;
    }

    public byte[] getByteArray(int minimumSize) {
        if (this.byteArray == null || this.byteArray.length < minimumSize) {
            this.byteArray = new byte[minimumSize];
        }
        return this.byteArray;
    }

    public void put(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(key, value);
    }

    public Object get(String key) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.get(key);
    }

    public void put(Serializer serializer, String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(new SerializerKey(serializer, key), value);
    }

    public Object get(Serializer serializer, String key) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.tempKey.serializer = serializer;
        this.tempKey.key = key;
        return this.map.get(this.tempKey);
    }

    public void putTemp(String key, Object value) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempMap.put(key, value);
    }

    public Object getTemp(String key) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        return this.tempMap.get(key);
    }

    public void putTemp(Serializer serializer, String key, Object value) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempMap.put(new SerializerKey(serializer, key), value);
    }

    public Object getTemp(Serializer serializer, String key) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempKey.serializer = serializer;
        this.tempKey.key = key;
        return this.tempMap.get(this.tempKey);
    }

    public void reset() {
        if (this.tempMap != null) {
            this.tempMap.clear();
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Context reset.");
        }
    }

    public int getRemoteEntityID() {
        return this.remoteEntityID;
    }

    public void setRemoteEntityID(int remoteEntityID) {
        this.remoteEntityID = remoteEntityID;
    }

    private static class SerializerKey {
        Serializer serializer;
        String key;

        public SerializerKey(Serializer serializer, String key) {
            this.serializer = serializer;
            this.key = key;
        }

        public int hashCode() {
            int result = 31 + this.key.hashCode();
            result = 31 * result + this.serializer.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerializerKey other = (SerializerKey)obj;
            if (!this.key.equals(other.key)) {
                return false;
            }
            return this.serializer.equals(other.serializer);
        }
    }
}

