/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Serializer {
    private static final byte NULL_OBJECT = 0;
    private static final byte NOT_NULL_OBJECT = 1;
    private boolean canBeNull = true;

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public final void writeObject(ByteBuffer buffer, Object object) {
        if (this.canBeNull) {
            if (object == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                buffer.put((byte)0);
                return;
            }
            buffer.put((byte)1);
        }
        this.writeObjectData(buffer, object);
    }

    public abstract void writeObjectData(ByteBuffer var1, Object var2);

    public final <T> T readObject(ByteBuffer buffer, Class<T> type) {
        if (this.canBeNull && buffer.get() == 0) {
            if (Log.TRACE) {
                Log.trace("kryo", "Read object: null");
            }
            return null;
        }
        return this.readObjectData(buffer, type);
    }

    public abstract <T> T readObjectData(ByteBuffer var1, Class<T> var2);

    public <T> T newInstance(Kryo kryo, Class<T> type) {
        return kryo.newInstance(type);
    }

    public boolean isFinal(Class type) {
        return Kryo.isFinal(type);
    }
}

