/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.compress;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Compressor;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Context;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.compress.Delta;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.util.IntHashMap;
import java.nio.ByteBuffer;

public class DeltaCompressor
extends Compressor {
    private final Kryo kryo;
    private final int chunkSize;
    final IntHashMap<ByteBuffer> contextToRemoteData = new IntHashMap();
    final IntHashMap<ByteBuffer> contextToLocalData = new IntHashMap();
    private Kryo.Listener removeBuffersListener = new Kryo.Listener(){

        public void remoteEntityRemoved(int id) {
            DeltaCompressor.this.contextToRemoteData.remove(id);
            DeltaCompressor.this.contextToLocalData.remove(id);
        }
    };

    public DeltaCompressor(Kryo kryo, Serializer serializer) {
        this(kryo, serializer, 2048, 8);
    }

    public DeltaCompressor(Kryo kryo, Serializer serializer, int bufferSize, int chunkSize) {
        super(serializer, bufferSize);
        this.kryo = kryo;
        this.chunkSize = chunkSize;
    }

    public void compress(ByteBuffer newData, Object object, ByteBuffer outputBuffer) {
        int start = newData.position();
        Context context = Kryo.getContext();
        int remoteID = context.getRemoteEntityID();
        ByteBuffer remoteData = this.contextToRemoteData.get(remoteID);
        Delta delta = (Delta)context.get(this, "com.googlecode.mobilityrpc.lib.delta");
        if (delta == null) {
            delta = new Delta(this.bufferSize, this.chunkSize);
            context.put(this, "com.googlecode.mobilityrpc.lib.delta", delta);
        }
        delta.compress(remoteData, newData, outputBuffer);
        if (remoteData == null) {
            remoteData = ByteBuffer.allocate(this.bufferSize);
            this.contextToRemoteData.put(remoteID, remoteData);
            this.kryo.addListener(this.removeBuffersListener);
        }
        remoteData.clear();
        newData.position(start);
        remoteData.put(newData);
        remoteData.flip();
    }

    public void decompress(ByteBuffer deltaData, Class type, ByteBuffer outputBuffer) {
        Context context = Kryo.getContext();
        int remoteID = context.getRemoteEntityID();
        ByteBuffer localData = this.contextToLocalData.get(remoteID);
        Delta delta = (Delta)context.get(this, "com.googlecode.mobilityrpc.lib.delta");
        if (delta == null) {
            delta = new Delta(this.bufferSize, this.chunkSize);
            context.put(this, "com.googlecode.mobilityrpc.lib.delta", delta);
        }
        delta.decompress(localData, deltaData, outputBuffer);
        if (localData == null) {
            localData = ByteBuffer.allocate(this.bufferSize);
            this.contextToLocalData.put(remoteID, localData);
            this.kryo.addListener(this.removeBuffersListener);
        }
        localData.clear();
        outputBuffer.flip();
        localData.put(outputBuffer);
        localData.flip();
    }
}

