/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.BigIntegerSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigDecimalSerializer
extends Serializer {
    private BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

    public BigDecimal readObjectData(ByteBuffer buffer, Class type) {
        BigInteger unscaledValue = (BigInteger)this.bigIntegerSerializer.readObjectData(buffer, (Class)null);
        int scale = IntSerializer.get(buffer, false);
        BigDecimal value = new BigDecimal(unscaledValue, scale);
        if (Log.TRACE) {
            Log.trace("kryo", "Read BigDecimal: " + value);
        }
        return value;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        BigDecimal value = (BigDecimal)object;
        this.bigIntegerSerializer.writeObjectData(buffer, value.unscaledValue());
        IntSerializer.put(buffer, value.scale(), false);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote BigDecimal: " + value);
        }
    }
}

