/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSerializer
extends Serializer {
    private final Kryo kryo;
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Integer length;

    public CollectionSerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementClass(Class elementClass) {
        this.elementClass = elementClass;
        this.serializer = elementClass == null ? null : this.kryo.getRegisteredClass(elementClass).getSerializer();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setElementClass(Class elementClass, Serializer serializer) {
        this.elementClass = elementClass;
        this.serializer = serializer;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        int length;
        Collection collection = (Collection)object;
        if (this.length != null) {
            length = this.length;
        } else {
            length = collection.size();
            IntSerializer.put(buffer, length, true);
        }
        if (length == 0) {
            return;
        }
        if (this.serializer != null) {
            if (this.elementsCanBeNull) {
                for (Object element : collection) {
                    this.serializer.writeObject(buffer, element);
                }
            } else {
                for (Object element : collection) {
                    this.serializer.writeObjectData(buffer, element);
                }
            }
        } else {
            for (Object element : collection) {
                this.kryo.writeClassAndObject(buffer, element);
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote collection: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        int length = this.length != null ? this.length : IntSerializer.get(buffer, true);
        Collection collection = type == ArrayList.class ? new ArrayList(length) : (Collection)this.newInstance(this.kryo, type);
        if (length == 0) {
            return (T)collection;
        }
        if (this.serializer != null) {
            if (this.elementsCanBeNull) {
                for (int i = 0; i < length; ++i) {
                    collection.add(this.serializer.readObject(buffer, this.elementClass));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    collection.add(this.serializer.readObjectData(buffer, this.elementClass));
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                collection.add(this.kryo.readClassAndObject(buffer));
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read collection: " + collection);
        }
        return (T)collection;
    }
}

