/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Context;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.NotNull;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Optional;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.util.Util;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer
extends Serializer {
    final Kryo kryo;
    final Class type;
    private CachedField[] fields;
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;

    public FieldSerializer(Kryo kryo, Class type) {
        this.kryo = kryo;
        this.type = type;
        this.rebuildCachedFields();
    }

    private void rebuildCachedFields() {
        int i;
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        ArrayList allFields = new ArrayList();
        for (Class nextClass = this.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allFields, nextClass.getDeclaredFields());
        }
        ArrayList<CachedField> asmFields = new ArrayList<CachedField>();
        PriorityQueue<CachedField> cachedFields = new PriorityQueue<CachedField>(Math.max(1, allFields.size()), new Comparator<CachedField>(){

            @Override
            public int compare(CachedField o1, CachedField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        Context context = Kryo.getContext();
        int n = allFields.size();
        for (i = 0; i < n; ++i) {
            Optional optional;
            Field field = (Field)allFields.get(i);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic() && this.ignoreSyntheticFields) continue;
            if (!field.isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && context.get(optional.value()) == null) continue;
            Class<?> fieldClass = field.getType();
            CachedField cachedField = new CachedField();
            cachedField.field = field;
            cachedField.canBeNull = this.fieldsCanBeNull ? !fieldClass.isPrimitive() && !field.isAnnotationPresent(NotNull.class) : false;
            if (this.isFinal(fieldClass)) {
                cachedField.fieldClass = fieldClass;
            }
            cachedFields.add(cachedField);
            if (Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isPublic(fieldClass.getModifiers())) continue;
            asmFields.add(cachedField);
        }
        if (!Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && !asmFields.isEmpty()) {
            try {
                this.access = FieldAccess.get(this.type);
                n = asmFields.size();
                for (i = 0; i < n; ++i) {
                    CachedField cachedField = (CachedField)asmFields.get(i);
                    cachedField.accessIndex = ((FieldAccess)this.access).getIndex(cachedField.field.getName());
                }
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
        }
        int fieldCount = cachedFields.size();
        this.fields = new CachedField[fieldCount];
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            this.fields[i2] = cachedFields.poll();
        }
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.fieldsCanBeNull = fieldsCanBeNull;
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.setFieldsAsAccessible = setFieldsAsAccessible;
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.ignoreSyntheticFields = ignoreSyntheticFields;
        this.rebuildCachedFields();
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        for (CachedField cachedField : this.fields) {
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Writing field: " + cachedField + " (" + object.getClass().getName() + ")");
                }
                Object value = cachedField.get(object);
                Serializer serializer = cachedField.serializer;
                if (cachedField.fieldClass == null) {
                    if (value == null) {
                        this.kryo.writeClass(buffer, null);
                        continue;
                    }
                    Kryo.RegisteredClass registeredClass = this.kryo.writeClass(buffer, value.getClass());
                    if (serializer == null) {
                        serializer = registeredClass.getSerializer();
                    }
                    serializer.writeObjectData(buffer, value);
                    continue;
                }
                if (serializer == null) {
                    cachedField.serializer = serializer = this.kryo.getRegisteredClass(cachedField.fieldClass).getSerializer();
                }
                if (!cachedField.canBeNull) {
                    serializer.writeObjectData(buffer, value);
                    continue;
                }
                serializer.writeObject(buffer, value);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + cachedField + " (" + object.getClass().getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(cachedField + " (" + object.getClass().getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(cachedField + " (" + object.getClass().getName() + ")");
                throw ex;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote object: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        return this.readObjectData(this.newInstance(this.kryo, type), buffer, type);
    }

    protected <T> T readObjectData(T object, ByteBuffer buffer, Class<T> type) {
        for (CachedField cachedField : this.fields) {
            try {
                Object value;
                if (Log.TRACE) {
                    Log.trace("kryo", "Reading field: " + cachedField + " (" + type.getName() + ")");
                }
                Class concreteType = cachedField.fieldClass;
                Serializer serializer = cachedField.serializer;
                if (concreteType == null) {
                    Kryo.RegisteredClass registeredClass = this.kryo.readClass(buffer);
                    if (registeredClass == null) {
                        value = null;
                    } else {
                        concreteType = registeredClass.getType();
                        if (serializer == null) {
                            serializer = registeredClass.getSerializer();
                        }
                        value = serializer.readObjectData(buffer, concreteType);
                    }
                } else {
                    if (serializer == null) {
                        cachedField.serializer = serializer = this.kryo.getRegisteredClass(concreteType).getSerializer();
                    }
                    value = !cachedField.canBeNull ? serializer.readObjectData(buffer, concreteType) : serializer.readObject(buffer, concreteType);
                }
                cachedField.set(object, value);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + cachedField + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(cachedField + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(cachedField + " (" + type.getName() + ")");
                throw ex;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read object: " + object);
        }
        return object;
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i);
            System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
            this.fields = newFields;
            return;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public class CachedField {
        Field field;
        Class fieldClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;

        public void setClass(Class fieldClass) {
            this.fieldClass = fieldClass;
            this.serializer = null;
        }

        public void setClass(Class fieldClass, Serializer serializer) {
            this.fieldClass = fieldClass;
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public String toString() {
            return this.field.getName();
        }

        Object get(Object object) throws IllegalAccessException {
            if (this.accessIndex != -1) {
                return ((FieldAccess)FieldSerializer.this.access).get(object, this.accessIndex);
            }
            return this.field.get(object);
        }

        void set(Object object, Object value) throws IllegalAccessException {
            if (this.accessIndex != -1) {
                ((FieldAccess)FieldSerializer.this.access).set(object, this.accessIndex, value);
            } else {
                this.field.set(object, value);
            }
        }
    }
}

