/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class LongSerializer
extends Serializer {
    private boolean optimizePositive;

    public LongSerializer() {
    }

    public LongSerializer(boolean optimizePositive) {
        this.optimizePositive = optimizePositive;
    }

    public Long readObjectData(ByteBuffer buffer, Class type) {
        long i = LongSerializer.get(buffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Read long: " + i);
        }
        return i;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        LongSerializer.put(buffer, (Long)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote long: " + object);
        }
    }

    public static long put(ByteBuffer buffer, long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 1L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 2L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 3L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 4L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 5L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 6L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 7L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 8L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        if (((value >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)value);
            return 9L;
        }
        buffer.put((byte)((int)value & 0x7F | 0x80));
        buffer.put((byte)(value >>>= 7));
        return 10L;
    }

    public static long get(ByteBuffer buffer, boolean optimizePositive) {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            byte b = buffer.get();
            result |= (long)(b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            if (!optimizePositive) {
                result = result >>> 1 ^ -(result & 1L);
            }
            return result;
        }
        throw new SerializationException("Malformed long.");
    }
}

