/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends Serializer {
    private final Kryo kryo;
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;

    public MapSerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setKeysCanBeNull(boolean keysCanBeNull) {
        this.keysCanBeNull = keysCanBeNull;
    }

    public void setKeyClass(Class keyClass) {
        this.keyClass = keyClass;
        this.keySerializer = keyClass == null ? null : this.kryo.getRegisteredClass(keyClass).getSerializer();
    }

    public void setKeyClass(Class keyClass, Serializer keySerializer) {
        this.keyClass = keyClass;
        this.keySerializer = keySerializer;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
        this.valueSerializer = valueClass == null ? null : this.kryo.getRegisteredClass(valueClass).getSerializer();
    }

    public void setValueClass(Class valueClass, Serializer valueSerializer) {
        this.valueClass = valueClass;
        this.valueSerializer = valueSerializer;
    }

    public void setValuesCanBeNull(boolean valuesCanBeNull) {
        this.valuesCanBeNull = valuesCanBeNull;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        Map map = (Map)object;
        int length = map.size();
        IntSerializer.put(buffer, length, true);
        if (length == 0) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (this.keySerializer != null) {
                if (this.keysCanBeNull) {
                    this.keySerializer.writeObject(buffer, entry.getKey());
                } else {
                    this.keySerializer.writeObjectData(buffer, entry.getKey());
                }
            } else {
                this.kryo.writeClassAndObject(buffer, entry.getKey());
            }
            if (this.valueSerializer != null) {
                if (this.valuesCanBeNull) {
                    this.valueSerializer.writeObject(buffer, entry.getValue());
                    continue;
                }
                this.valueSerializer.writeObjectData(buffer, entry.getValue());
                continue;
            }
            this.kryo.writeClassAndObject(buffer, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote map: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        Map map = (Map)this.newInstance(this.kryo, type);
        int length = IntSerializer.get(buffer, true);
        if (length == 0) {
            return (T)map;
        }
        for (int i = 0; i < length; ++i) {
            Object key = this.keySerializer != null ? (this.keysCanBeNull ? this.keySerializer.readObject(buffer, this.keyClass) : this.keySerializer.readObjectData(buffer, this.keyClass)) : this.kryo.readClassAndObject(buffer);
            Object value = this.valueSerializer != null ? (this.valuesCanBeNull ? this.valueSerializer.readObject(buffer, this.valueClass) : this.valueSerializer.readObjectData(buffer, this.valueClass)) : this.kryo.readClassAndObject(buffer);
            map.put(key, value);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read map: " + map);
        }
        return (T)map;
    }
}

