/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.SerializationException;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableSerializer
extends Serializer {
    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        T object = SerializableSerializer.get(buffer, type);
        if (Log.TRACE) {
            Log.trace("kryo", "Read object: " + object);
        }
        return object;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object object) {
        SerializableSerializer.put(buffer, object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote object: " + object);
        }
    }

    public static void put(ByteBuffer buffer, Object object) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(256);
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(object);
            objectStream.close();
            byte[] array = byteStream.toByteArray();
            IntSerializer.put(buffer, array.length, true);
            buffer.put(array);
        }
        catch (BufferOverflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SerializationException("Error during Java serialization.", ex);
        }
    }

    public static <T> T get(ByteBuffer buffer, Class<T> type) {
        int length = IntSerializer.get(buffer, true);
        byte[] array = new byte[length];
        buffer.get(array);
        try {
            return (T)new ObjectInputStream(new ByteArrayInputStream(array)).readObject();
        }
        catch (Exception ex) {
            throw new SerializationException("Error during Java deserialization.", ex);
        }
    }
}

