/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortHashMap<T> {
    private Entry[] table;
    private float loadFactor;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    public ShortHashMap() {
        this(16, 0.75f);
    }

    public ShortHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public boolean containsValue(Object value) {
        Entry[] table = this.table;
        int i = table.length;
        while (i-- > 0) {
            Entry e = table[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(short key) {
        int index = key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public T get(short key) {
        int index = key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return (T)e.value;
            }
            e = e.next;
        }
        return null;
    }

    public T put(short key, T value) {
        int index = key & this.mask;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return (T)oldValue;
            }
            e = e.next;
        }
        this.table[index] = new Entry(key, value, this.table[index]);
        if (this.size++ >= this.threshold) {
            int newCapacity = 2 * this.capacity;
            Entry[] newTable = new Entry[newCapacity];
            Entry[] src = this.table;
            int newMask = newCapacity - 1;
            for (int j = 0; j < src.length; ++j) {
                Entry next;
                Entry e2 = src[j];
                if (e2 == null) continue;
                src[j] = null;
                do {
                    next = e2.next;
                    index = e2.key & newMask;
                    e2.next = newTable[index];
                    newTable[index] = e2;
                } while ((e2 = next) != null);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.mask = newMask;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        }
        return null;
    }

    public T remove(short key) {
        Entry prev;
        int index = key & this.mask;
        Entry e = prev = this.table[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                return (T)e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry[] table = this.table;
        int index = table.length;
        while (--index >= 0) {
            table[index] = null;
        }
        this.size = 0;
    }

    static class Entry {
        final short key;
        Object value;
        Entry next;

        Entry(short k, Object v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }
    }
}

