/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.IntSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.minlog.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Iterator;

public class EnumSetSerializer
extends SimpleSerializer<EnumSet> {
    private static final Field TYPE_FIELD;
    private final Kryo _kryo;

    public EnumSetSerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    @Override
    public EnumSet read(ByteBuffer buffer) {
        Class elementType = this._kryo.readClass(buffer).getType();
        EnumSet result = EnumSet.noneOf(elementType);
        int size = IntSerializer.get(buffer, true);
        for (int i = 0; i < size; ++i) {
            result.add(EnumSerializer.get(buffer, elementType));
        }
        return result;
    }

    @Override
    public void write(ByteBuffer buffer, EnumSet set) {
        this._kryo.writeClass(buffer, this.getElementType(set));
        IntSerializer.put(buffer, set.size(), true);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            EnumSerializer.put(buffer, (Enum)iter.next());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote EnumSet: " + set);
        }
    }

    private Class getElementType(EnumSet<? extends Enum<?>> set) {
        try {
            return (Class)TYPE_FIELD.get(set);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access keys field.", e);
        }
    }

    static {
        try {
            TYPE_FIELD = EnumSet.class.getDeclaredField("elementType");
            TYPE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("The EnumSet class seems to have changed, could not access expected field.", e);
        }
    }
}

