/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.cglib;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serialize.SimpleSerializer;
import java.nio.ByteBuffer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;

public class CGLibProxySerializer
extends SimpleSerializer<Object> {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";
    private final Kryo _kryo;

    public CGLibProxySerializer(Kryo kryo) {
        this._kryo = kryo;
    }

    public static boolean canSerialize(Class<?> cls) {
        return Enhancer.isEnhanced(cls) && cls.getName().indexOf(DEFAULT_NAMING_MARKER) > 0;
    }

    @Override
    public Object read(ByteBuffer buffer) {
        Class superclass = this._kryo.readClass(buffer).getType();
        Class[] interfaces = this._kryo.readObjectData(buffer, Class[].class);
        Callback[] callbacks = this._kryo.readObjectData(buffer, Callback[].class);
        return this.createProxy(superclass, interfaces, callbacks);
    }

    @Override
    public void write(ByteBuffer buffer, Object obj) {
        this._kryo.writeClass(buffer, obj.getClass().getSuperclass());
        this._kryo.writeObjectData(buffer, obj.getClass().getInterfaces());
        this._kryo.writeObjectData(buffer, ((Factory)obj).getCallbacks());
    }

    private Object createProxy(Class<?> targetClass, Class<?>[] interfaces, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setInterfaces((Class[])interfaces);
        e.setSuperclass(targetClass);
        e.setCallbacks(callbacks);
        return e.create();
    }

    public static interface CGLibProxyMarker {
    }
}

