/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.converters;

import com.googlecode.mobilityrpc.protocol.converters.MessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.EnvelopeMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.ExecutionRequestMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.ExecutionResponseMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.PingMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.PongMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.ResourceRequestMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.messages.ResourceResponseMessageConverter;
import com.googlecode.mobilityrpc.protocol.pojo.Envelope;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionResponse;
import com.googlecode.mobilityrpc.protocol.pojo.Ping;
import com.googlecode.mobilityrpc.protocol.pojo.Pong;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import java.util.HashMap;
import java.util.Map;

public class MessageConverterRegistry {
    private final Map<Class<?>, MessageConverter<?>> converters = new HashMap();

    public MessageConverterRegistry() {
        this.register(Envelope.class, new EnvelopeMessageConverter());
        this.register(ResourceRequest.class, new ResourceRequestMessageConverter());
        this.register(ResourceResponse.class, new ResourceResponseMessageConverter());
        this.register(ExecutionRequest.class, new ExecutionRequestMessageConverter());
        this.register(ExecutionResponse.class, new ExecutionResponseMessageConverter());
        this.register(Ping.class, new PingMessageConverter());
        this.register(Pong.class, new PongMessageConverter());
    }

    void register(Class<?> messageClass, MessageConverter<?> messageConverter) {
        this.converters.put(messageClass, messageConverter);
    }

    public <T> MessageConverter<T> getConverter(Class<T> messageClass) {
        MessageConverter<?> result = this.converters.get(messageClass);
        if (result == null) {
            throw new IllegalStateException("No MessageConverter for message type: " + messageClass);
        }
        return result;
    }
}

