/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.controller.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.ConnectionManager;
import com.googlecode.mobilityrpc.network.impl.ConnectionManagerImpl;
import com.googlecode.mobilityrpc.network.impl.ConnectionManagerInternal;
import com.googlecode.mobilityrpc.protocol.converters.MasterMessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.MessageConverter;
import com.googlecode.mobilityrpc.protocol.converters.MessageConverterRegistry;
import com.googlecode.mobilityrpc.protocol.converters.MessageTypeRegistry;
import com.googlecode.mobilityrpc.protocol.pojo.Envelope;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessorRegistry;
import com.googlecode.mobilityrpc.session.MobilitySession;
import com.googlecode.mobilityrpc.session.impl.MobilitySessionImpl;
import com.googlecode.mobilityrpc.session.impl.MobilitySessionInternal;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MobilityControllerImpl
implements MobilityControllerInternal {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ConnectionManagerInternal connectionManager;
    private final ExecutorService messageProcessorService = Executors.newCachedThreadPool();
    private final MessageTypeRegistry messageTypeToClassRegistry = new MessageTypeRegistry();
    private final MessageConverterRegistry messageConverterRegistry = new MessageConverterRegistry();
    private final DeserializedMessageProcessorRegistry deserializedMessageProcessorRegistry = new DeserializedMessageProcessorRegistry();
    private final MasterMessageConverter masterMessageConverter = new MasterMessageConverter();
    private final ConcurrentMap<UUID, MobilitySessionInternal> sessionRegistry = new ConcurrentHashMap<UUID, MobilitySessionInternal>();

    public MobilityControllerImpl() {
        this.connectionManager = new ConnectionManagerImpl(this);
        this.connectionManager.init();
    }

    @Override
    public void receiveIncomingMessage(ConnectionId connectionId, byte[] message) {
        this.messageProcessorService.submit(new MessageProcessorTask(connectionId, message));
    }

    @Override
    public void sendOutgoingMessage(ConnectionId identifier, Object message) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Serializing and submitting outgoing message to '" + identifier + "': " + message);
        }
        byte[] messageDataInEnvelope = this.masterMessageConverter.convertToProtobuf(message);
        this.connectionManager.getConnection(identifier).enqueueOutgoingMessage(messageDataInEnvelope);
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void destroy() {
        this.connectionManager.destroy();
        this.messageProcessorService.shutdown();
        this.sessionRegistry.clear();
    }

    @Override
    public MobilitySession getSession(UUID sessionId) {
        return this.getMessageHandlingSession(sessionId);
    }

    @Override
    public MobilitySession newSession() {
        return this.getSession(UUID.randomUUID());
    }

    @Override
    public void releaseSession(UUID sessionId) {
        MobilitySession session = (MobilitySession)this.sessionRegistry.get(sessionId);
        if (session == null) {
            return;
        }
        this.sessionRegistry.remove(sessionId);
    }

    @Override
    public MobilitySessionInternal getMessageHandlingSession(UUID sessionId) {
        MobilitySessionInternal session = (MobilitySessionInternal)this.sessionRegistry.get(sessionId);
        if (session != null) {
            this.logger.log(Level.FINER, "Found and returning existing session: {0}", session);
            return session;
        }
        MobilitySessionImpl newSession = new MobilitySessionImpl(sessionId, this);
        MobilitySessionInternal existingSession = this.sessionRegistry.putIfAbsent(sessionId, newSession);
        if (existingSession == null) {
            this.logger.log(Level.FINER, "No existing session found, created registered and returning now a new session: {0}", newSession);
            return newSession;
        }
        this.logger.log(Level.FINER, "No existing session found, however another thread won race with this thread to create one, returning session recently created by another thread: {0}", existingSession);
        return existingSession;
    }

    class MessageProcessorTask
    implements Runnable {
        private final ConnectionId connectionId;
        private final byte[] messageData;

        MessageProcessorTask(ConnectionId connectionId, byte[] messageData) {
            this.connectionId = connectionId;
            this.messageData = messageData;
        }

        @Override
        public void run() {
            this.processMessage(this.connectionId, this.messageData);
        }

        public <T> void processMessage(ConnectionId connectionId, byte[] messageData) {
            try {
                if (MobilityControllerImpl.this.logger.isLoggable(Level.FINEST)) {
                    MobilityControllerImpl.this.logger.log(Level.FINEST, "Processing incoming message: " + messageData.length + " bytes from " + connectionId);
                }
                Envelope envelope = MobilityControllerImpl.this.messageConverterRegistry.getConverter(Envelope.class).convertFromProtobuf(messageData);
                Class<?> messageClass = MobilityControllerImpl.this.messageTypeToClassRegistry.getMessageClass(envelope.getMessageType());
                MessageConverter<?> messageConverter = MobilityControllerImpl.this.messageConverterRegistry.getConverter(messageClass);
                DeserializedMessageProcessor<?> deserializedMessageProcessor = MobilityControllerImpl.this.deserializedMessageProcessorRegistry.getProcessor(messageClass);
                Object message = messageConverter.convertFromProtobuf(envelope.getMessage());
                if (MobilityControllerImpl.this.logger.isLoggable(Level.FINE)) {
                    MobilityControllerImpl.this.logger.log(Level.FINE, "Received message and submitting for processing, " + messageData.length + " bytes from '" + connectionId + "': " + message);
                }
                deserializedMessageProcessor.process(MobilityControllerImpl.this, MobilityControllerImpl.this.connectionManager, connectionId, message);
            }
            catch (Exception e) {
                MobilityControllerImpl.this.logger.log(Level.WARNING, "Failed to process incoming message: " + messageData.length + " bytes from: " + connectionId, e);
            }
        }
    }
}

