/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class JdkProxySerializer
extends Serializer<Object> {
    @Override
    public Object read(Kryo kryo, Input input, Class<Object> type) {
        InvocationHandler invocationHandler = (InvocationHandler)kryo.readClassAndObject(input);
        Class[] interfaces = kryo.readObject(input, Class[].class);
        ClassLoader classLoader = kryo.getClassLoader();
        try {
            return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        }
        catch (RuntimeException e) {
            System.err.println(this.getClass().getName() + ".read:\n" + "Could not create proxy using classLoader " + classLoader + "," + " have invocationhandler.classloader: " + invocationHandler.getClass().getClassLoader() + " have contextclassloader: " + Thread.currentThread().getContextClassLoader());
            throw e;
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Object obj) {
        kryo.writeClassAndObject(output, Proxy.getInvocationHandler(obj));
        kryo.writeObject(output, obj.getClass().getInterfaces());
    }

    @Override
    public Object copy(Kryo kryo, Object original) {
        return Proxy.newProxyInstance(kryo.getClassLoader(), original.getClass().getInterfaces(), Proxy.getInvocationHandler(original));
    }
}

