/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime.IdentifiableChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.Chronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.Interval;

public class JodaIntervalSerializer
extends Serializer<Interval> {
    public JodaIntervalSerializer() {
        this.setImmutable(true);
    }

    @Override
    public Interval read(Kryo kryo, Input input, Class<Interval> type) {
        long startMillis = input.readLong(true);
        long endMillis = input.readLong(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new Interval(startMillis, endMillis, chronology);
    }

    @Override
    public void write(Kryo kryo, Output output, Interval obj) {
        long startMillis = obj.getStartMillis();
        long endMillis = obj.getEndMillis();
        String chronologyId = IdentifiableChronology.getChronologyId(obj.getChronology());
        output.writeLong(startMillis, true);
        output.writeLong(endMillis, true);
        output.writeString(chronologyId == null ? "" : chronologyId);
    }
}

