/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime.IdentifiableChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.Chronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.LocalDateTime;

public class JodaLocalDateTimeSerializer
extends Serializer<LocalDateTime> {
    public JodaLocalDateTimeSerializer() {
        this.setImmutable(true);
    }

    @Override
    public LocalDateTime read(Kryo kryo, Input input, Class<LocalDateTime> type) {
        long packedLocalDateTime = input.readLong(true);
        int packedYearMonthDay = (int)(packedLocalDateTime / 86400000L);
        int millisOfDay = (int)(packedLocalDateTime % 86400000L);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new LocalDateTime(packedYearMonthDay / 416, packedYearMonthDay % 416 / 32, packedYearMonthDay % 32, millisOfDay / 3600000, millisOfDay % 3600000 / 60000, millisOfDay % 60000 / 1000, millisOfDay % 1000, chronology);
    }

    @Override
    public void write(Kryo kryo, Output output, LocalDateTime localDateTime) {
        int packedYearMonthDay = localDateTime.getYear() * 13 * 32 + localDateTime.getMonthOfYear() * 32 + localDateTime.getDayOfMonth();
        output.writeLong((long)packedYearMonthDay * 86400000L + (long)localDateTime.getMillisOfDay(), true);
        String chronologyId = IdentifiableChronology.getChronologyId(localDateTime.getChronology());
        output.writeString(chronologyId == null ? "" : chronologyId);
    }
}

