/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.session.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionClassLoader
extends ClassLoader {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final long RESOURCE_REQUEST_TIMEOUT_MILLIS = 10000L;
    private final MobilityControllerInternal mobilityController;
    private final UUID sessionId;
    private final ThreadLocal<ConnectionId> threadLocalConnectionIds = new ThreadLocal();
    private final ConcurrentMap<RequestIdentifier, FutureResourceResponse> futureResourceResponses = new ConcurrentHashMap<RequestIdentifier, FutureResourceResponse>();
    private final Map<String, byte[]> resourceDataCache = new ConcurrentHashMap<String, byte[]>();

    public SessionClassLoader(MobilityControllerInternal mobilityController, UUID sessionId) {
        super(SessionClassLoader.class.getClassLoader());
        this.mobilityController = mobilityController;
        this.sessionId = sessionId;
    }

    public void setThreadLocalConnectionId(ConnectionId connectionId) {
        this.threadLocalConnectionIds.set(connectionId);
    }

    public void processResourceResponse(ResourceResponse resourceResponse) {
        RequestIdentifier requestIdentifier = resourceResponse.getRequestIdentifier();
        FutureResourceResponse futureResourceResponse = (FutureResourceResponse)this.futureResourceResponses.get(requestIdentifier);
        if (futureResourceResponse == null) {
            this.logger.log(Level.FINE, "Ignored ResourceResponse, no pending request found, request must have timed out: {0}", resourceResponse);
            return;
        }
        futureResourceResponse.setResponse(resourceResponse);
        this.logger.log(Level.FINE, "Accepted ResourceResponse, passed to request thread: {0}", resourceResponse);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String resourceName = name.replace('.', '/') + ".class";
            byte[] requiredResourceData = this.resourceDataCache.get(resourceName);
            if (requiredResourceData != null) {
                return this.defineClass(name, requiredResourceData, 0, requiredResourceData.length);
            }
            ConnectionId threadLocalConnectionId = this.threadLocalConnectionIds.get();
            if (threadLocalConnectionId == null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "No bytecode cached for class: " + name);
                }
                throw new ClassNotFoundException("No bytecode previously cached for this class");
            }
            List<String> requiredClasses = Collections.singletonList(resourceName);
            FutureResourceResponse futureResponse = this.sendResourceRequest(requiredClasses);
            ResourceResponse resourceResponse = futureResponse.getResponse(10000L, TimeUnit.MILLISECONDS);
            for (ResourceResponse.ResourceData resourceData : resourceResponse.getResourceDataResponses()) {
                if (!resourceName.equals(resourceData.getResourceName())) continue;
                requiredResourceData = resourceData.getResourceData();
                this.resourceDataCache.put(resourceName, requiredResourceData);
                break;
            }
            if (requiredResourceData == null) {
                throw new ClassNotFoundException("The remote machine could not locate bytecode for the requested class: " + name + ", resource name: " + resourceName);
            }
            return this.defineClass(name, requiredResourceData, 0, requiredResourceData.length);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Could not locate bytecode for the requested class: " + name, t);
        }
    }

    @Override
    protected URL findResource(String name) {
        try {
            byte[] requiredResourceData = this.resourceDataCache.get(name);
            if (requiredResourceData != null) {
                return SessionClassLoader.wrapAsUrl("local-cache:0:0", this.sessionId.toString(), name, requiredResourceData);
            }
            ConnectionId threadLocalConnectionId = this.threadLocalConnectionIds.get();
            if (threadLocalConnectionId == null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "No content cached for resource: " + name);
                }
                return null;
            }
            List<String> requiredResources = Collections.singletonList(name);
            FutureResourceResponse futureResponse = this.sendResourceRequest(requiredResources);
            ResourceResponse resourceResponse = futureResponse.getResponse(10000L, TimeUnit.MILLISECONDS);
            for (ResourceResponse.ResourceData resourceData : resourceResponse.getResourceDataResponses()) {
                if (!name.equals(resourceData.getResourceName())) continue;
                requiredResourceData = resourceData.getResourceData();
                this.resourceDataCache.put(name, requiredResourceData);
                break;
            }
            if (requiredResourceData == null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "The remote machine could not locate the requested resource: " + name);
                }
                return null;
            }
            return SessionClassLoader.wrapAsUrl(threadLocalConnectionId.toString(), this.sessionId.toString(), name, requiredResourceData);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unexpected exception locating the requested resource: " + name, t);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL resourceUrl = this.findResource(name);
        return resourceUrl == null ? Collections.enumeration(Collections.emptySet()) : Collections.enumeration(Collections.singleton(resourceUrl));
    }

    static URL wrapAsUrl(String connectionId, String sessionId, String resourceName, final byte[] resourceData) {
        try {
            return new URL("mobility-rpc", connectionId, -1, "/" + sessionId + "/" + resourceName, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public Object getContent() throws IOException {
                            return this.getInputStream();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(resourceData);
                        }
                    };
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to wrap resource as URL: connection: " + connectionId + ", session: " + sessionId + ", resource: " + resourceName, e);
        }
    }

    FutureResourceResponse sendResourceRequest(List<String> requestedResources) {
        ConnectionId threadLocalConnectionId = this.threadLocalConnectionIds.get();
        if (threadLocalConnectionId == null) {
            throw new IllegalStateException("No thread-local connection id is registered for the thread requesting classes: " + requestedResources);
        }
        UUID requestId = UUID.randomUUID();
        RequestIdentifier requestIdentifier = new RequestIdentifier(this.sessionId, requestId, "Request for resources: " + requestedResources);
        FutureResourceResponse futureResourceResponse = new FutureResourceResponse(requestIdentifier);
        this.futureResourceResponses.put(requestIdentifier, futureResourceResponse);
        ResourceRequest resourceRequest = new ResourceRequest(requestedResources, requestIdentifier);
        this.mobilityController.sendOutgoingMessage(threadLocalConnectionId, resourceRequest);
        return futureResourceResponse;
    }

    class FutureResourceResponse {
        private final RequestIdentifier requestIdentifier;
        private final BlockingQueue<ResourceResponse> responseQueue = new ArrayBlockingQueue<ResourceResponse>(1);

        FutureResourceResponse(RequestIdentifier requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        public ResourceResponse getResponse(long timeout, TimeUnit unit) {
            try {
                ResourceResponse resourceResponse = this.responseQueue.poll(timeout, unit);
                if (resourceResponse == null) {
                    throw new TimeoutException();
                }
                ResourceResponse resourceResponse2 = resourceResponse;
                return resourceResponse2;
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timed out waiting to receive class bytecode or resource within timeout of " + timeout + " " + unit.name().toLowerCase(), e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception waiting to receive bytecode or resource", e);
            }
            finally {
                SessionClassLoader.this.futureResourceResponses.remove(this.requestIdentifier);
            }
        }

        public boolean setResponse(ResourceResponse resourceResponse) {
            return this.responseQueue.add(resourceResponse);
        }
    }
}

