/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.com.google.protobuf;

import com.googlecode.mobilityrpc.lib.com.google.protobuf.ByteString;
import com.googlecode.mobilityrpc.lib.com.google.protobuf.CodedInputStream;
import com.googlecode.mobilityrpc.lib.com.google.protobuf.CodedOutputStream;
import com.googlecode.mobilityrpc.lib.com.google.protobuf.InvalidProtocolBufferException;
import com.googlecode.mobilityrpc.lib.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, EMPTY_INT_ARRAY, EMPTY_OBJECT_ARRAY);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static UnknownFieldSetLite concat(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        int count = first.count + second.count;
        int[] tags = Arrays.copyOf(first.tags, count);
        System.arraycopy(second.tags, 0, tags, first.count, second.count);
        Object[] objects = Arrays.copyOf(first.objects, count);
        System.arraycopy(second.objects, 0, objects, first.count, second.count);
        return new UnknownFieldSetLite(count, tags, objects);
    }

    private UnknownFieldSetLite(int count, int[] tags, Object[] objects) {
        this.count = count;
        this.tags = tags;
        this.objects = objects;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        block7: for (int i = 0; i < this.count; ++i) {
            int tag = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    output.writeUInt64(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    output.writeFixed32(fieldNumber, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    output.writeFixed64(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    output.writeBytes(fieldNumber, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    output.writeTag(fieldNumber, 3);
                    ((UnknownFieldSetLite)this.objects[i]).writeTo(output);
                    output.writeTag(fieldNumber, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public int getSerializedSize() {
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        block7: for (int i = 0; i < this.count; ++i) {
            int tag = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    size += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    size += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    size += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    size += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    size += CodedOutputStream.computeTagSize(fieldNumber) * 2 + ((UnknownFieldSetLite)this.objects[i]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
        return this.count == other.count && Arrays.equals(this.tags, other.tags) && Arrays.deepEquals(this.objects, other.objects);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.count;
        hashCode = 31 * hashCode + Arrays.hashCode(this.tags);
        hashCode = 31 * hashCode + Arrays.deepHashCode(this.objects);
        return hashCode;
    }

    static /* synthetic */ int[] access$100() {
        return EMPTY_INT_ARRAY;
    }

    static /* synthetic */ Object[] access$200() {
        return EMPTY_OBJECT_ARRAY;
    }

    public static final class Builder {
        private static final int MIN_CAPACITY = 8;
        private int count = 0;
        private int[] tags = UnknownFieldSetLite.access$100();
        private Object[] objects = UnknownFieldSetLite.access$200();
        private boolean built;

        private Builder() {
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("Do not reuse UnknownFieldSetLite Builders.");
            }
        }

        private void storeField(int tag, Object value) {
            this.ensureCapacity();
            this.tags[this.count] = tag;
            this.objects[this.count] = value;
            ++this.count;
        }

        private void ensureCapacity() {
            if (this.count == this.tags.length) {
                int increment = this.count < 4 ? 8 : this.count >> 1;
                int newLength = this.count + increment;
                this.tags = Arrays.copyOf(this.tags, newLength);
                this.objects = Arrays.copyOf(this.objects, newLength);
            }
        }

        public boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
            this.ensureNotBuilt();
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.storeField(tag, input.readInt64());
                    return true;
                }
                case 5: {
                    this.storeField(tag, input.readFixed32());
                    return true;
                }
                case 1: {
                    this.storeField(tag, input.readFixed64());
                    return true;
                }
                case 2: {
                    this.storeField(tag, input.readBytes());
                    return true;
                }
                case 3: {
                    Builder subBuilder = UnknownFieldSetLite.newBuilder();
                    subBuilder.mergeFrom(input);
                    input.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                    this.storeField(tag, subBuilder.build());
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        public Builder mergeVarintField(int fieldNumber, int value) {
            if (fieldNumber == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            this.ensureNotBuilt();
            this.storeField(WireFormat.makeTag(fieldNumber, 0), value);
            return this;
        }

        public Builder mergeLengthDelimitedField(int fieldNumber, ByteString value) {
            if (fieldNumber == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            this.ensureNotBuilt();
            this.storeField(WireFormat.makeTag(fieldNumber, 2), value);
            return this;
        }

        private Builder mergeFrom(CodedInputStream input) throws IOException {
            int tag;
            while ((tag = input.readTag()) != 0 && this.mergeFieldFrom(tag, input)) {
            }
            return this;
        }

        public UnknownFieldSetLite build() {
            if (this.built) {
                throw new IllegalStateException("Do not reuse UnknownFieldSetLite Builders.");
            }
            this.built = true;
            if (this.count == 0) {
                return DEFAULT_INSTANCE;
            }
            return new UnknownFieldSetLite(this.count, this.tags, this.objects);
        }
    }
}

