/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class UnmodifiableCollectionsSerializer
extends Serializer<Object> {
    private static final Field SOURCE_COLLECTION_FIELD;
    private static final Field SOURCE_MAP_FIELD;

    @Override
    public Object read(Kryo kryo, Input input, Class<Object> clazz) {
        int ordinal = input.readInt(true);
        UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.values()[ordinal];
        Object sourceCollection = kryo.readClassAndObject(input);
        return unmodifiableCollection.create(sourceCollection);
    }

    @Override
    public void write(Kryo kryo, Output output, Object object) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(object.getClass());
            output.writeInt(unmodifiableCollection.ordinal(), true);
            kryo.writeClassAndObject(output, unmodifiableCollection.sourceCollectionField.get(object));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object copy(Kryo kryo, Object original) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(original.getClass());
            Object sourceCollectionCopy = kryo.copy(unmodifiableCollection.sourceCollectionField.get(original));
            return unmodifiableCollection.create(sourceCollectionCopy);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        UnmodifiableCollectionsSerializer serializer = new UnmodifiableCollectionsSerializer();
        UnmodifiableCollection.values();
        for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
            kryo.register(item.type, serializer);
        }
    }

    static /* synthetic */ Field access$100() {
        return SOURCE_COLLECTION_FIELD;
    }

    static /* synthetic */ Field access$300() {
        return SOURCE_MAP_FIELD;
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Class.forName("java.util.Collections$UnmodifiableCollection").getDeclaredField("c");
            SOURCE_COLLECTION_FIELD.setAccessible(true);
            SOURCE_MAP_FIELD = Class.forName("java.util.Collections$UnmodifiableMap").getDeclaredField("m");
            SOURCE_MAP_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access source collection field in java.util.Collections$UnmodifiableCollection.", e);
        }
    }

    private static enum UnmodifiableCollection {
        COLLECTION((Class)Collections.unmodifiableCollection(Arrays.asList("")).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.unmodifiableList(new ArrayList<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.unmodifiableList(new LinkedList<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.unmodifiableSet(new HashSet<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.unmodifiableSortedSet(new TreeSet<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.unmodifiableMap(new HashMap<K, V>()).getClass(), UnmodifiableCollectionsSerializer.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.unmodifiableSortedMap(new TreeMap<K, V>()).getClass(), UnmodifiableCollectionsSerializer.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;
        private final Field sourceCollectionField;

        private UnmodifiableCollection(Class<?> type, Field sourceCollectionField) {
            this.type = type;
            this.sourceCollectionField = sourceCollectionField;
        }

        public abstract Object create(Object var1);

        static UnmodifiableCollection valueOfType(Class<?> type) {
            for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + type + " is not supported.");
        }
    }
}

