/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.cglib;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;

public class CGLibProxySerializer
extends Serializer<Object> {
    public static final String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";

    public static boolean canSerialize(Class<?> cls) {
        return Enhancer.isEnhanced(cls) && cls.getName().indexOf(DEFAULT_NAMING_MARKER) > 0;
    }

    @Override
    public Object read(Kryo kryo, Input input, Class<Object> type) {
        Class superclass = kryo.readClass(input).getType();
        Class[] interfaces = kryo.readObject(input, Class[].class);
        Callback[] callbacks = kryo.readObject(input, Callback[].class);
        return this.createProxy(superclass, interfaces, callbacks);
    }

    @Override
    public void write(Kryo kryo, Output output, Object obj) {
        kryo.writeClass(output, obj.getClass().getSuperclass());
        kryo.writeObject(output, obj.getClass().getInterfaces());
        kryo.writeObject(output, ((Factory)obj).getCallbacks());
    }

    private Object createProxy(Class<?> targetClass, Class<?>[] interfaces, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setInterfaces((Class[])interfaces);
        e.setSuperclass(targetClass);
        e.setCallbacks(callbacks);
        return e.create();
    }

    public static interface CGLibProxyMarker {
    }
}

