/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.jodatime.IdentifiableChronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.Chronology;
import com.googlecode.mobilityrpc.lib.org.joda.time.DateTime;
import com.googlecode.mobilityrpc.lib.org.joda.time.DateTimeZone;

public class JodaDateTimeSerializer
extends Serializer<DateTime> {
    static final String MILLIS = "millis";
    static final String DATE_TIME = "dt";
    static final String CHRONOLOGY = "ch";
    static final String TIME_ZONE = "tz";

    public JodaDateTimeSerializer() {
        this.setImmutable(true);
    }

    @Override
    public DateTime read(Kryo kryo, Input input, Class<DateTime> type) {
        long millis = input.readLong(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        DateTimeZone tz = this.readTimeZone(input);
        return new DateTime(millis, chronology.withZone(tz));
    }

    @Override
    public void write(Kryo kryo, Output output, DateTime obj) {
        output.writeLong(obj.getMillis(), true);
        String chronologyId = IdentifiableChronology.getChronologyId(obj.getChronology());
        output.writeString(chronologyId == null ? "" : chronologyId);
        output.writeString(obj.getZone().getID());
    }

    private DateTimeZone readTimeZone(Input input) {
        String tz = input.readString();
        if ("".equals(tz)) {
            return DateTimeZone.getDefault();
        }
        return DateTimeZone.forID((String)tz);
    }
}

