/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.serialization.impl;

import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Kryo;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.factories.SerializerFactory;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Input;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.io.Output;
import com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.ArraysAsListSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.JdkProxySerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import com.googlecode.mobilityrpc.lib.de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import com.googlecode.mobilityrpc.lib.org.objenesis.strategy.StdInstantiatorStrategy;
import com.googlecode.mobilityrpc.serialization.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.GregorianCalendar;

public class KryoSerializer
implements Serializer {
    private final Kryo kryo = new Kryo();

    public KryoSerializer(ClassLoader classLoader) {
        this.kryo.setDefaultSerializer(new SerializerFactory(){

            @Override
            public com.googlecode.mobilityrpc.lib.com.esotericsoftware.kryo.Serializer makeSerializer(Kryo kryo, Class<?> type) {
                FieldSerializer fieldSerializer = new FieldSerializer(kryo, type);
                fieldSerializer.setIgnoreSyntheticFields(false);
                return fieldSerializer;
            }
        });
        this.kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        this.kryo.setClassLoader(classLoader);
        this.kryo.register(Arrays.asList(new Object[0]).getClass(), new ArraysAsListSerializer());
        this.kryo.register(GregorianCalendar.class, new GregorianCalendarSerializer());
        this.kryo.register(InvocationHandler.class, new JdkProxySerializer());
        UnmodifiableCollectionsSerializer.registerSerializers(this.kryo);
        SynchronizedCollectionsSerializer.registerSerializers(this.kryo);
    }

    @Override
    public byte[] serialize(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output(baos);
        this.kryo.writeClassAndObject(output, object);
        output.flush();
        output.close();
        return baos.toByteArray();
    }

    @Override
    public Object deserialize(byte[] serializedData) {
        Input input = new Input(new ByteArrayInputStream(serializedData));
        Object object = this.kryo.readClassAndObject(input);
        input.close();
        return object;
    }
}

