/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.session.impl;

import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.session.MobilitySession;

public class MobilityContextInternal {
    private static final ThreadLocal<MobilitySession> threadLocalSessions = new ThreadLocal();
    private static final ThreadLocal<ConnectionId> threadLocalConnectionIds = new ThreadLocal();

    protected static MobilitySession getCurrentSession() {
        MobilitySession currentSession = threadLocalSessions.get();
        if (currentSession == null) {
            throw new IllegalStateException("No current session");
        }
        return currentSession;
    }

    protected static boolean hasCurrentSession() {
        MobilitySession currentSession = threadLocalSessions.get();
        return currentSession != null;
    }

    static void setCurrentSession(MobilitySession session) {
        threadLocalSessions.set(session);
    }

    protected static ConnectionId getCurrentConnectionId() {
        ConnectionId currentConnectionId = threadLocalConnectionIds.get();
        if (currentConnectionId == null) {
            throw new IllegalStateException("No current connection id");
        }
        return currentConnectionId;
    }

    static void setCurrentConnectionId(ConnectionId connectionId) {
        threadLocalConnectionIds.set(connectionId);
    }

    protected MobilityContextInternal() {
    }
}

