/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.processors;

import com.googlecode.mobilityrpc.protocol.pojo.ExecutionRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionResponse;
import com.googlecode.mobilityrpc.protocol.pojo.Ping;
import com.googlecode.mobilityrpc.protocol.pojo.Pong;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceRequest;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.ExecutionRequestMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.ExecutionResponseMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.PingMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.PongMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.ResourceRequestMessageProcessor;
import com.googlecode.mobilityrpc.protocol.processors.impl.ResourceResponseMessageProcessor;
import java.util.HashMap;
import java.util.Map;

public class DeserializedMessageProcessorRegistry {
    private final Map<Class<?>, DeserializedMessageProcessor<?>> converters = new HashMap<Class<?>, DeserializedMessageProcessor<?>>(){
        {
            this.put(ExecutionRequest.class, new ExecutionRequestMessageProcessor());
            this.put(ExecutionResponse.class, new ExecutionResponseMessageProcessor());
            this.put(ResourceRequest.class, new ResourceRequestMessageProcessor());
            this.put(ResourceResponse.class, new ResourceResponseMessageProcessor());
            this.put(Ping.class, new PingMessageProcessor());
            this.put(Pong.class, new PongMessageProcessor());
        }
    };

    public <T> DeserializedMessageProcessor<T> getProcessor(Class<T> messageClass) {
        DeserializedMessageProcessor<?> result = this.converters.get(messageClass);
        if (result == null) {
            throw new IllegalStateException("No DeserializedMessageProcessor for message type: " + messageClass);
        }
        return result;
    }
}

