/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.protocol.processors.impl;

import com.googlecode.mobilityrpc.controller.impl.MobilityControllerInternal;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.network.ConnectionManager;
import com.googlecode.mobilityrpc.protocol.pojo.RequestIdentifier;
import com.googlecode.mobilityrpc.protocol.pojo.ResourceResponse;
import com.googlecode.mobilityrpc.protocol.processors.DeserializedMessageProcessor;
import com.googlecode.mobilityrpc.session.MobilitySession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceResponseMessageProcessor
implements DeserializedMessageProcessor<ResourceResponse> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void process(MobilityControllerInternal mobilityController, ConnectionManager connectionManager, ConnectionId connectionId, ResourceResponse resourceResponse) {
        RequestIdentifier requestIdentifier = resourceResponse.getRequestIdentifier();
        MobilitySession session = mobilityController.getSession(requestIdentifier.getSessionId());
        this.logger.log(Level.FINER, "Received ResourceResponse, submitting to session class loader: {0}", resourceResponse);
        session.getSessionClassLoader().processResourceResponse(resourceResponse);
    }
}

