/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.quickstart;

import com.googlecode.mobilityrpc.MobilityRPC;
import com.googlecode.mobilityrpc.network.ConnectionId;
import com.googlecode.mobilityrpc.protocol.pojo.ExecutionMode;
import com.googlecode.mobilityrpc.session.MobilityContext;
import com.googlecode.mobilityrpc.session.MobilitySession;
import java.util.concurrent.Callable;

public class QuickTask {
    public static void execute(String address, Runnable runnable) {
        QuickTask.execute(new ConnectionId(address, 5739), runnable);
    }

    public static void execute(String address, long executionResponseTimeoutMs, Runnable runnable) {
        QuickTask.execute(new ConnectionId(address, 5739), executionResponseTimeoutMs, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ConnectionId connectionId, Runnable runnable) {
        MobilitySession session = MobilityRPC.newController().newSession();
        try {
            session.execute(connectionId, (Runnable)new SessionReleasingRunnable(runnable));
        }
        finally {
            session.getMobilityController().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ConnectionId connectionId, long executionResponseTimeoutMs, Runnable runnable) {
        MobilitySession session = MobilityRPC.newController().newSession();
        try {
            session.execute(connectionId, ExecutionMode.RETURN_RESPONSE, executionResponseTimeoutMs, new SessionReleasingRunnable(runnable));
        }
        finally {
            session.getMobilityController().destroy();
        }
    }

    public static <T> T execute(String address, Callable<T> callable) {
        return QuickTask.execute(new ConnectionId(address, 5739), callable);
    }

    public static <T> T execute(String address, long executionResponseTimeoutMs, Callable<T> callable) {
        return QuickTask.execute(new ConnectionId(address, 5739), executionResponseTimeoutMs, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(ConnectionId connectionId, Callable<T> callable) {
        MobilitySession session = MobilityRPC.newController().newSession();
        try {
            T t = session.execute(connectionId, new SessionReleasingCallable<T>(callable));
            return t;
        }
        finally {
            session.getMobilityController().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(ConnectionId connectionId, long executionResponseTimeoutMs, Callable<T> callable) {
        MobilitySession session = MobilityRPC.newController().newSession();
        try {
            T t = session.execute(connectionId, ExecutionMode.RETURN_RESPONSE, executionResponseTimeoutMs, new SessionReleasingCallable<T>(callable));
            return t;
        }
        finally {
            session.getMobilityController().destroy();
        }
    }

    QuickTask() {
    }

    static class SessionReleasingCallable<T>
    implements Callable<T> {
        private final Callable<T> wrapped;

        SessionReleasingCallable(Callable<T> wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                T t = this.wrapped.call();
                return t;
            }
            finally {
                MobilityContext.getCurrentSession().release();
            }
        }
    }

    static class SessionReleasingRunnable
    implements Runnable {
        private final Runnable wrapped;

        SessionReleasingRunnable(Runnable wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.wrapped.run();
            }
            finally {
                MobilityContext.getCurrentSession().release();
            }
        }
    }
}

