/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mobilityrpc.quickstart.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingUtil {
    public static void setPackageLoggingLevel(String packageRoot, Level level) {
        Logger appLogger = Logger.getLogger(packageRoot);
        appLogger.setLevel(level);
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
        }
    }

    public static void setLibraryLoggingLevel(Level level) {
        LoggingUtil.setPackageLoggingLevel("com.googlecode.mobilityrpc", level);
    }

    public static void setSingleLineLoggingFormat() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setFormatter(new SingleLineFormater());
        }
    }

    static class SingleLineFormater
    extends Formatter {
        private final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        private final DecimalFormat THREAD_ID_FORMAT = new DecimalFormat("000");
        private final String lineSeparator = System.getProperty("line.separator", "\n");

        SingleLineFormater() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ISO_8601_DATE_FORMAT.format(record.getMillis()));
            sb.append("\tThread-");
            sb.append(this.THREAD_ID_FORMAT.format(record.getThreadID()));
            sb.append("\t");
            sb.append(record.getLevel().getLocalizedName());
            sb.append("\t");
            if (record.getSourceClassName() != null) {
                sb.append(SingleLineFormater.getSimpleClassName(record.getSourceClassName()));
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(".");
                sb.append(record.getSourceMethodName());
            }
            sb.append("\t");
            String message = this.formatMessage(record);
            sb.append(message);
            sb.append(this.lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return sb.toString();
        }

        static String getSimpleClassName(String fullyQualifiedClassName) {
            int index = fullyQualifiedClassName.lastIndexOf(46);
            if (index == -1) {
                return fullyQualifiedClassName;
            }
            if (index + 1 >= fullyQualifiedClassName.length()) {
                return fullyQualifiedClassName;
            }
            return fullyQualifiedClassName.substring(index + 1);
        }
    }
}

