/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.msidor.maven.plugins.hpalm.deliverynote;

import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.EntitiesRoot;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.Entity;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.Field;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import sun.misc.BASE64Encoder;

public class HPALMMavenPlugin
extends AbstractMojo {
    private String url = null;
    private String login = null;
    private String password = null;
    private String query = null;
    private Map<String, String> valuesToUpdate = null;
    private Map<String, String> queryValues = null;
    private Map<String, String> translationOfValuesToExport = null;
    private List<String> valuesToExport = null;
    private String domain = null;
    private String project = null;
    private String confluenceServer = null;
    private String confleunceUser = null;
    private String confluencePassword = null;
    private Object confluencePageID = null;
    private String confluenceKeyWordForUpdate = null;
    private String updateHeader = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Authenticate to HP ALM");
        String cokie = this.authenticate(this.url + "/qcbin/authentication-point/authenticate", this.login, this.password);
        this.getLog().info((CharSequence)"Prepare HP ALM query statement");
        if (this.query == null) {
            this.query = "";
            Set<String> keys = this.queryValues.keySet();
            boolean isFirstItem = true;
            for (String key : keys) {
                String value = this.queryValues.get(key);
                try {
                    key = URLEncoder.encode(key, "UTF-8").replace("+", "%20");
                    value = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.query = this.query + (isFirstItem ? "" : ";") + key + "[%22" + value + "%22]";
                isFirstItem = false;
            }
        }
        this.getLog().debug((CharSequence)("Final HP ALM query: " + this.query));
        this.getLog().info((CharSequence)"Execute HP ALM query");
        boolean hasMoreentities = true;
        int startIndex = 1;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        while (hasMoreentities) {
            String res = this.get(this.url + "/qcbin/rest/domains/" + this.domain + "/projects/" + this.project + "/defects?page-size=10&start-index=" + startIndex + "&query={" + this.query + "}", cokie);
            List<Entity> entitiesToAdd = this.parse(res);
            if (entitiesToAdd != null) {
                entities.addAll(entitiesToAdd);
            }
            startIndex += 10;
            hasMoreentities = entities != null && entities.size() == 10;
        }
        this.getLog().info((CharSequence)"Generate summary HTML table report for CONLUENCE");
        StringBuilder html = new StringBuilder();
        html.append("<table><tbody>");
        html.append("<tr>");
        for (String key : this.valuesToExport) {
            String value = null;
            value = this.translationOfValuesToExport != null && this.translationOfValuesToExport.containsKey(key) ? this.translationOfValuesToExport.get(key) : key;
            if (value == null || value.trim().isEmpty()) {
                value = "&nbsp;";
            }
            html.append("<th>" + value + "</th>");
        }
        html.append("</tr>");
        for (Entity entity : entities) {
            this.getHTMLForEntity(entity, html);
        }
        html.append("</tbody></table>");
        this.getLog().debug((CharSequence)("Generated HTML code: " + html));
        this.getLog().info((CharSequence)"Update CONLUENCE");
        try {
            this.updateConfluencePage(html.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getLog().info((CharSequence)"Generate changes file");
        this.getLog().info((CharSequence)"Update HP ALM entities");
        for (Entity entity : entities) {
            String xml = this.getUpdateStatement(entity);
            this.getLog().debug((CharSequence)("Update statement: " + xml));
            this.put(this.url + "/qcbin/rest/domains/" + this.domain + "/projects/" + this.project + "/defects/" + entity.id, xml, cokie);
        }
    }

    private void updateConfluencePage(String contentToAdd) throws Exception {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(this.confluenceServer + "/rpc/xmlrpc"));
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        Object result = client.execute("confluence2.login", (Object[])new String[]{this.confleunceUser, this.confluencePassword});
        HashMap page = (HashMap)client.execute("confluence2.getPage", new Object[]{result, this.confluencePageID});
        this.getLog().debug((CharSequence)("Current CONFLUENCE page: " + page));
        String content = (String)page.get("content");
        int i = content.indexOf(this.confluenceKeyWordForUpdate);
        content = (i += this.confluenceKeyWordForUpdate.length()) >= 0 ? content.substring(0, i) + this.updateHeader + contentToAdd + content.substring(i) : this.updateHeader + contentToAdd + content;
        this.getLog().debug((CharSequence)("and the new content: " + content));
        page.put("content", content);
        HashMap pageUpdateOptions = new HashMap();
        page = (HashMap)client.execute("confluence2.updatePage", new Object[]{result, page, pageUpdateOptions});
    }

    private void getHTMLForEntity(Entity entity, StringBuilder html) {
        html.append("<tr>");
        for (String key : this.valuesToExport) {
            String value = "&nbsp;";
            if (entity.fields != null) {
                List<Field> fields = entity.fields;
                for (Field field : fields) {
                    if (!key.equalsIgnoreCase(field.name)) continue;
                    value = field.value;
                }
            }
            html.append("<td>" + value + "</td>");
        }
        html.append("</tr>");
    }

    public String getUpdateStatement(Entity entity) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><Entity Type=\"defect\"><Fields>";
        Set<String> keys = this.valuesToUpdate.keySet();
        for (String key : keys) {
            String value = this.valuesToUpdate.get(key);
            xml = xml + "<Field Name=\"" + key + "\"><Value>" + value + "</Value></Field>";
        }
        xml = xml + "</Fields></Entity>";
        return xml;
    }

    public List<Entity> parse(String xmlBody) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntitiesRoot.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader reader = new StringReader(xmlBody);
            EntitiesRoot entitiesRoot = (EntitiesRoot)unmarshaller.unmarshal((Reader)reader);
            if (entitiesRoot != null) {
                if (entitiesRoot.entities != null) {
                    block2: for (Entity entity : entitiesRoot.entities) {
                        if (entity.fields == null) continue;
                        for (Field field : entity.fields) {
                            if (!field.name.equalsIgnoreCase("id")) continue;
                            entity.id = field.value;
                            continue block2;
                        }
                    }
                }
                return entitiesRoot.entities;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String targetURL, String urlParameters, String cookie) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/xml");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("Accept", "application/xml");
            if (cookie != null) {
                connection.setRequestProperty("Cookie", cookie);
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            StringBuffer response = new StringBuffer();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            resultToReturn = response.toString();
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while posting data to HP ALM", "Error occurced while posting data to HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String targetURL, String cookie) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/xml");
            if (cookie != null) {
                connection.setRequestProperty("Cookie", cookie);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuffer response = new StringBuffer();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            resultToReturn = response.toString();
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while retrieving data from HP ALM", "Error occurced while retrieving data from HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String targetURL, String username, String password) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            String authorization = null;
            if (username != null && password != null) {
                authorization = username + ":" + password;
            }
            if (authorization != null) {
                BASE64Encoder enc = new BASE64Encoder();
                String encodedBytes = enc.encode(authorization.getBytes());
                authorization = "Basic " + encodedBytes;
                connection.setRequestProperty("Authorization", authorization);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.getResponseCode();
            resultToReturn = connection.getHeaderField("Set-Cookie");
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while authenticating to HP ALM", "Error occurced while retrieving authenticating to HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }
}

