/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.msidor.maven.plugins.hpalm.deliverynote;

import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.DefaultHPALMMojoDAO;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.EntitiesRoot;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.Entity;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.Field;
import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.HPALMMojoDAOI;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class HPALMMojo
extends AbstractMojo {
    private String url = null;
    private String login = null;
    private String password = null;
    private String query = null;
    private Map<String, String> valuesToUpdate = null;
    private Map<String, String> queryValues = null;
    private Map<String, String> translationOfValuesToExport = null;
    private List<String> valuesToExport = null;
    private String domain = null;
    private String project = null;
    private String confluenceServer = null;
    private String confleunceUser = null;
    private String confluencePassword = null;
    private String confluencePageID = null;
    private String confluenceKeyWordForUpdate = null;
    private String updateHeader = null;
    private String changesOutputFilePath = null;
    private Map<String, String> changesFixIssuesFilter = null;
    private Map<String, String> changesAddIssuesFilter = null;
    private Map<String, String> changesUpdateIssuesFilter = null;
    private Map<String, String> changesRemoveIssuesFilter = null;
    private String changesDevFiledMapping = null;
    private String changesDescFiledMapping = null;
    private String changesDueToFiledMapping = null;
    private String changesProjectVersion = null;
    private HPALMMojoDAOI dao = new DefaultHPALMMojoDAO();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Authenticating to HP ALM...");
        String cokie = null;
        try {
            cokie = this.dao.authenticateToHPALM(this.url, this.login, this.password);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not authenticate to HP ALM", e);
        }
        this.getLog().info((CharSequence)"Preparing HP ALM query statement...");
        try {
            this.buildQueryStatement();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not produce HP ALM query", e);
        }
        this.getLog().info((CharSequence)"Executing HP ALM query...");
        List<Entity> entities = null;
        try {
            entities = this.retreiveEntities(cokie);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not execute HP ALM query", e);
        }
        if (this.confluenceServer != null) {
            this.getLog().info((CharSequence)"Generating summary HTML table report for CONLUENCE...");
            StringBuilder html = null;
            try {
                html = this.generateHTML(entities);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not Generate summary HTML table report for CONLUENCE", e);
            }
            this.getLog().info((CharSequence)"Updating CONLUENCE page...");
            try {
                this.updateConfluencePage(html.toString());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not update CONLUENCE page", e);
            }
        }
        if (this.changesOutputFilePath != null) {
            this.getLog().info((CharSequence)"Generating changes file...");
            try {
                this.generateChangesXML(entities);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not generate changes file", e);
            }
        }
        if (this.valuesToUpdate != null && this.valuesToUpdate.size() > 0) {
            this.getLog().info((CharSequence)"Updating HP ALM entities...");
            try {
                this.updateEntities(cokie, entities);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not update HP ALM entities", e);
            }
        }
    }

    private void updateEntities(String cokie, List<Entity> entities) throws Exception {
        for (Entity entity : entities) {
            String xml = this.getUpdateStatement(entity);
            this.getLog().debug((CharSequence)("Update statement: " + xml));
            this.dao.putToHPALM(this.url + "/qcbin/rest/domains/" + this.domain + "/projects/" + this.project + "/defects/" + entity.id, xml, cokie);
        }
    }

    private void generateChangesXML(List<Entity> entities) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.changesOutputFilePath), Charset.forName("UTF-8")));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<document>\n");
        writer.write("<body>\n");
        writer.write("<release version=\"" + this.changesProjectVersion + "\" date=\"" + Calendar.getInstance().getTime().toString() + "\">\n");
        for (Entity entity : entities) {
            writer.write("<action dev=\"" + entity.dev + "\" type=\"" + entity.changeType + "\" issue=\"" + entity.id + "\" due-to=\"" + entity.dueTo + "\">\n");
            writer.write(entity.desc);
            writer.write("\n</action>\n");
        }
        writer.write("</release>\n");
        writer.write("</body>\n");
        writer.write("</document>\n");
        writer.flush();
        writer.close();
    }

    private StringBuilder generateHTML(List<Entity> entities) throws Exception {
        StringBuilder html = new StringBuilder();
        html.append("<table><tbody>");
        html.append("<tr>");
        for (String key : this.valuesToExport) {
            String value = null;
            value = this.translationOfValuesToExport != null && this.translationOfValuesToExport.containsKey(key) ? this.translationOfValuesToExport.get(key) : key;
            if (value == null || value.trim().isEmpty()) {
                value = "&nbsp;";
            }
            html.append("<th>" + value + "</th>");
        }
        html.append("</tr>");
        for (Entity entity : entities) {
            this.getHTMLForEntity(entity, html);
        }
        html.append("</tbody></table>");
        this.getLog().debug((CharSequence)("Generated HTML code: " + html));
        return html;
    }

    private List<Entity> retreiveEntities(String cokie) throws Exception {
        boolean hasMoreEntities = true;
        int startIndex = 1;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        while (hasMoreEntities) {
            String finalURL = this.url + "/qcbin/rest/domains/" + this.domain + "/projects/" + this.project + "/defects?page-size=10&start-index=" + startIndex + "&query={" + this.query + "}";
            this.getLog().debug((CharSequence)("Final HP ALM url: " + finalURL));
            String res = this.dao.getFromHPALM(finalURL, cokie);
            List<Entity> entitiesToAdd = this.parse(res);
            if (entitiesToAdd != null) {
                entities.addAll(entitiesToAdd);
            }
            startIndex += 10;
            hasMoreEntities = entities != null && entities.size() == 10;
        }
        return entities;
    }

    private void buildQueryStatement() {
        if (this.query == null) {
            this.query = "";
            Set<String> keys = this.queryValues.keySet();
            boolean isFirstItem = true;
            for (String key : keys) {
                String value = this.queryValues.get(key);
                try {
                    key = URLEncoder.encode(key, "UTF-8").replace("+", "%20");
                    value = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.query = this.query + (isFirstItem ? "" : ";") + key + "[%22" + value + "%22]";
                isFirstItem = false;
            }
        }
        this.getLog().debug((CharSequence)("Final HP ALM query: " + this.query));
    }

    private void updateConfluencePage(String contentToAdd) throws Exception {
        this.dao.initializeXmlRpcClient(this.confluenceServer);
        Object result = this.dao.authenticateToConfluence(this.confleunceUser, this.confluencePassword);
        HashMap<Object, Object> page = this.dao.getConfluencePage(result, this.confluencePageID);
        this.getLog().debug((CharSequence)("Current CONFLUENCE page: " + page));
        String content = (String)page.get("content");
        int i = -1;
        if (this.confluenceKeyWordForUpdate != null) {
            i = content.indexOf(this.confluenceKeyWordForUpdate);
        }
        if (this.updateHeader == null) {
            this.updateHeader = "";
        }
        content = i >= 0 ? content.substring(0, i += this.confluenceKeyWordForUpdate.length()) + this.updateHeader + contentToAdd + content.substring(i) : this.updateHeader + contentToAdd + content;
        this.getLog().debug((CharSequence)("and the new content: " + content));
        page.put("content", content);
        HashMap<Object, Object> pageUpdateOptions = new HashMap<Object, Object>();
        this.dao.updateConfluencePage(result, page, pageUpdateOptions);
    }

    private void getHTMLForEntity(Entity entity, StringBuilder html) {
        html.append("<tr>");
        for (String key : this.valuesToExport) {
            String value = "&nbsp;";
            if (entity.fields != null) {
                List<Field> fields = entity.fields;
                for (Field field : fields) {
                    if (!key.equalsIgnoreCase(field.name)) continue;
                    value = field.value;
                }
            }
            html.append("<td>" + value + "</td>");
        }
        html.append("</tr>");
    }

    public String getUpdateStatement(Entity entity) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><Entity Type=\"defect\"><Fields>";
        Set<String> keys = this.valuesToUpdate.keySet();
        for (String key : keys) {
            String value = this.valuesToUpdate.get(key);
            xml = xml + "<Field Name=\"" + key + "\"><Value>" + value + "</Value></Field>";
        }
        xml = xml + "</Fields></Entity>";
        return xml;
    }

    public List<Entity> parse(String xmlBody) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EntitiesRoot.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader reader = new StringReader(xmlBody);
            EntitiesRoot entitiesRoot = (EntitiesRoot)unmarshaller.unmarshal((Reader)reader);
            if (entitiesRoot != null) {
                if (entitiesRoot.entities != null) {
                    for (Entity entity : entitiesRoot.entities) {
                        int countOfFixTypeConditionsValidated = 0;
                        int countOfAddTypeConditionsValidated = 0;
                        int countOfUpdateTypeConditionsValidated = 0;
                        int countOfRemoveTypeConditionsValidated = 0;
                        if (entity.fields != null) {
                            for (Field field : entity.fields) {
                                if (field.name.equalsIgnoreCase("id")) {
                                    entity.id = field.value;
                                }
                                if (field.name.equalsIgnoreCase(this.changesDevFiledMapping)) {
                                    entity.dev = field.value;
                                }
                                if (field.name.equalsIgnoreCase(this.changesDescFiledMapping)) {
                                    entity.desc = field.value;
                                }
                                if (field.name.equalsIgnoreCase(this.changesDueToFiledMapping)) {
                                    entity.dueTo = field.value;
                                }
                                if (this.changesAddIssuesFilter != null && this.changesAddIssuesFilter.containsKey(field.name) && this.changesAddIssuesFilter.get(field.name).equalsIgnoreCase(field.value)) {
                                    ++countOfAddTypeConditionsValidated;
                                }
                                if (this.changesFixIssuesFilter != null && this.changesFixIssuesFilter.containsKey(field.name) && this.changesFixIssuesFilter.get(field.name).equalsIgnoreCase(field.value)) {
                                    ++countOfFixTypeConditionsValidated;
                                }
                                if (this.changesUpdateIssuesFilter != null && this.changesUpdateIssuesFilter.containsKey(field.name) && this.changesUpdateIssuesFilter.get(field.name).equalsIgnoreCase(field.value)) {
                                    ++countOfUpdateTypeConditionsValidated;
                                }
                                if (this.changesRemoveIssuesFilter == null || !this.changesRemoveIssuesFilter.containsKey(field.name) || !this.changesRemoveIssuesFilter.get(field.name).equalsIgnoreCase(field.value)) continue;
                                ++countOfRemoveTypeConditionsValidated;
                            }
                        }
                        if (this.changesFixIssuesFilter != null && this.changesFixIssuesFilter.size() == countOfFixTypeConditionsValidated) {
                            entity.changeType = "FIX";
                        }
                        if (this.changesAddIssuesFilter != null && this.changesAddIssuesFilter.size() == countOfAddTypeConditionsValidated) {
                            entity.changeType = "ADD";
                        }
                        if (this.changesUpdateIssuesFilter != null && this.changesUpdateIssuesFilter.size() == countOfUpdateTypeConditionsValidated) {
                            entity.changeType = "UPDATE";
                        }
                        if (this.changesRemoveIssuesFilter == null || this.changesRemoveIssuesFilter.size() != countOfRemoveTypeConditionsValidated) continue;
                        entity.changeType = "REMOVE";
                    }
                }
                return entitiesRoot.entities;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return null;
    }

    public HPALMMojoDAOI getDao() {
        return this.dao;
    }

    public void setDao(HPALMMojoDAOI dao) {
        this.dao = dao;
    }
}

