/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.msidor.maven.plugins.hpalm.deliverynote;

import com.googlecode.msidor.maven.plugins.hpalm.deliverynote.HPALMMojoDAOI;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import sun.misc.BASE64Encoder;

public class DefaultHPALMMojoDAO
implements HPALMMojoDAOI {
    private XmlRpcClient client;

    @Override
    public void updateConfluencePage(Object cookie, HashMap<Object, Object> page, HashMap<Object, Object> pageUpdateOptions) throws XmlRpcException {
        this.client.execute("confluence2.updatePage", new Object[]{cookie, page, pageUpdateOptions});
    }

    @Override
    public HashMap<Object, Object> getConfluencePage(Object cookie, String confluencePageID) throws XmlRpcException {
        HashMap page = (HashMap)this.client.execute("confluence2.getPage", new Object[]{cookie, confluencePageID});
        return page;
    }

    @Override
    public Object authenticateToConfluence(String confleunceUser, String confluencePassword) throws XmlRpcException {
        Object result = this.client.execute("confluence2.login", (Object[])new String[]{confleunceUser, confluencePassword});
        return result;
    }

    @Override
    public void initializeXmlRpcClient(String confluenceServer) throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(confluenceServer + "/rpc/xmlrpc"));
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putToHPALM(String targetURL, String urlParameters, String cookie) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/xml");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("Accept", "application/xml");
            if (cookie != null) {
                connection.setRequestProperty("Cookie", cookie);
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            StringBuffer response = new StringBuffer();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            resultToReturn = response.toString();
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while posting data to HP ALM", "Error occurced while posting data to HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFromHPALM(String targetURL, String cookie) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/xml");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            if (cookie != null) {
                connection.setRequestProperty("Cookie", cookie);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuffer response = new StringBuffer();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            resultToReturn = response.toString();
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while retrieving data from HP ALM", "Error occurced while retrieving data from HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticateToHPALM(String targetURL, String username, String password) throws MojoFailureException {
        HttpURLConnection connection = null;
        MojoFailureException exceptionToThrow = null;
        String resultToReturn = null;
        try {
            URL url = new URL(targetURL + "/qcbin/authentication-point/authenticate");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            String authorization = null;
            if (username != null && password != null) {
                authorization = username + ":" + password;
            }
            if (authorization != null) {
                BASE64Encoder enc = new BASE64Encoder();
                String encodedBytes = enc.encode(authorization.getBytes());
                authorization = "Basic " + encodedBytes;
                connection.setRequestProperty("Authorization", authorization);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.getResponseCode();
            resultToReturn = connection.getHeaderField("Set-Cookie");
        }
        catch (Exception e) {
            String detailInfo = null;
            if (connection != null) {
                try {
                    detailInfo = "Response code: " + connection.getResponseCode();
                    detailInfo = detailInfo + "; Response message: " + connection.getResponseMessage();
                }
                catch (IOException eInternal) {
                    // empty catch block
                }
            }
            exceptionToThrow = new MojoFailureException((Object)e, "Error occurced while authenticating to HP ALM", "Error occurced while retrieving authenticating to HP ALM: " + (detailInfo != null ? detailInfo : e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return resultToReturn;
    }
}

