/**
 * Copyright 2011 The PlayN Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package flash.ui;

/**
 * Contains Flash key code constants.
 */
public class Keyboard
{
  public static final int A = 65;
  public static final int ALTERNATE = 18;
  public static final int AUDIO = 0x01000017;
  public static final int B = 66;
  public static final int BACK = 0x01000016;
  public static final int BACKQUOTE = 192;
  public static final int BACKSLASH = 220;
  public static final int BACKSPACE = 8;
  public static final int BLUE = 0x01000003;
  public static final int C = 67;
  public static final int CAPS_LOCK = 20;
  public static final int CHANNEL_DOWN = 0x01000005;
  public static final int CHANNEL_UP = 0x01000004;
  public static final int COMMA = 188;
  public static final int COMMAND = 15;
  public static final int CONTROL = 17;
  public static final int D = 68;
  public static final int DELETE = 46;
  public static final int DOWN = 40;
  public static final int DVR = 0x01000019;
  public static final int E = 69;
  public static final int END = 35;
  public static final int ENTER = 13;
  public static final int EQUAL = 187;
  public static final int ESCAPE = 27;
  public static final int EXIT = 0x01000015;
  public static final int F = 70;
  public static final int F1 = 112;
  public static final int F10 = 121;
  public static final int F11 = 122;
  public static final int F12 = 123;
  public static final int F13 = 124;
  public static final int F14 = 125;
  public static final int F15 = 126;
  public static final int F2 = 113;
  public static final int F3 = 114;
  public static final int F4 = 115;
  public static final int F5 = 116;
  public static final int F6 = 117;
  public static final int F7 = 118;
  public static final int F8 = 119;
  public static final int F9 = 120;
  public static final int FAST_FORWARD = 0x0100000A;
  public static final int G = 71;
  public static final int GREEN = 0x01000001;
  public static final int GUIDE = 0x01000014;
  public static final int H = 72;
  public static final int HELP = 0x0100001D;
  public static final int HOME = 36;
  public static final int I = 73;
  public static final int INFO = 0x01000013;
  public static final int INPUT = 0x0100001B;
  public static final int INSERT = 45;
  public static final int J = 74;
  public static final int K = 75;
  public static final int L = 76;
  public static final int LAST = 0x01000011;
  public static final int LEFT = 37;
  public static final int LEFTBRACKET = 219;
  public static final int LIVE = 0x01000010;
  public static final int M = 77;
  public static final int MASTER_SHELL = 0x0100001E;
  public static final int MENU = 0x01000012;
  public static final int MINUS = 189;
  public static final int N = 78;
  public static final int NEXT = 0x0100000E;
  public static final int NUMBER_0 = 48;
  public static final int NUMBER_1 = 49;
  public static final int NUMBER_2 = 50;
  public static final int NUMBER_3 = 51;
  public static final int NUMBER_4 = 52;
  public static final int NUMBER_5 = 53;
  public static final int NUMBER_6 = 54;
  public static final int NUMBER_7 = 55;
  public static final int NUMBER_8 = 56;
  public static final int NUMBER_9 = 57;
  public static final int NUMPAD = 21;
  public static final int NUMPAD_0 = 96;
  public static final int NUMPAD_1 = 97;
  public static final int NUMPAD_2 = 98;
  public static final int NUMPAD_3 = 99;
  public static final int NUMPAD_4 = 100;
  public static final int NUMPAD_5 = 101;
  public static final int NUMPAD_6 = 102;
  public static final int NUMPAD_7 = 103;
  public static final int NUMPAD_8 = 104;
  public static final int NUMPAD_9 = 105;
  public static final int NUMPAD_ADD = 107;
  public static final int NUMPAD_DECIMAL = 110;
  public static final int NUMPAD_DIVIDE = 111;
  public static final int NUMPAD_ENTER = 108;
  public static final int NUMPAD_MULTIPLY = 106;
  public static final int NUMPAD_SUBTRACT = 109;
  public static final int O = 79;
  public static final int P = 80;
  public static final int PAGE_DOWN = 34;
  public static final int PAGE_UP = 33;
  public static final int PAUSE = 0x01000008;
  public static final int PERIOD = 190;
  public static final int PLAY = 0x01000007;
  public static final int PREVIOUS = 0x0100000F;
  public static final int Q = 81;
  public static final int QUOTE = 222;
  public static final int R = 82;
  public static final int RECORD = 0x01000006;
  public static final int RED = 0x01000000;
  public static final int REWIND = 0x0100000B;
  public static final int RIGHT = 39;
  public static final int RIGHTBRACKET = 221;
  public static final int S = 83;
  public static final int SEARCH = 0x0100001F;
  public static final int SEMICOLON = 186;
  public static final int SETUP = 0x0100001C;
  public static final int SHIFT = 16;
  public static final int SKIP_BACKWARD = 0x0100000D;
  public static final int SKIP_FORWARD = 0x0100000C;
  public static final int SLASH = 191;
  public static final int SPACE = 32;
  public static final int STOP = 0x01000009;
  public static final int SUBTITLE = 0x01000018;
  public static final int T = 84;
  public static final int TAB = 9;
  public static final int U = 85;
  public static final int UP = 38;
  public static final int V = 86;
  public static final int VOD = 0x0100001A;
  public static final int W = 87;
  public static final int X = 88;
  public static final int Y = 89;
  public static final int YELLOW = 0x01000002;
  public static final int Z = 90;
};
