/**
 * Copyright 2012 The PlayN Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package playn.flash;

import playn.core.Surface;
import playn.core.SurfaceImage;
import playn.core.canvas.CanvasSurface;
import playn.core.gl.GLContext;

public class FlashSurfaceImageCanvas extends FlashCanvasImage implements SurfaceImage {

  private final CanvasSurface surface;

  public FlashSurfaceImageCanvas(FlashCanvas canvas) {
    super(canvas);
    surface = new CanvasSurface(canvas);
  }

  @Override
  public Surface surface() {
    return surface;
  }

  @Override
  public void destroy() {
    // nothing to see here, move it along
  }
}
