/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.uikit.UIImage;
import playn.core.AbstractAssets;
import playn.core.AbstractPlatform;
import playn.core.AsyncImage;
import playn.core.Image;
import playn.core.Net;
import playn.core.Sound;
import playn.core.gl.GLContext;
import playn.core.gl.Scale;
import playn.core.util.Callback;
import playn.robovm.RoboAsyncImage;
import playn.robovm.RoboImage;
import playn.robovm.RoboPlatform;

public class RoboAssets
extends AbstractAssets<UIImage> {
    private final RoboPlatform platform;
    private final File bundleRoot = new File(NSBundle.getMainBundle().getBundlePath());
    private File assetRoot = new File(this.bundleRoot, "assets");

    public RoboAssets(RoboPlatform platform) {
        super((AbstractPlatform)platform);
        this.platform = platform;
    }

    public void setPathPrefix(String pathPrefix) {
        this.assetRoot = new File(this.bundleRoot, pathPrefix);
    }

    public Image getRemoteImage(String url, float width, float height) {
        final RoboAsyncImage image = new RoboAsyncImage((GLContext)this.platform.graphics().ctx, width, height);
        this.platform.net().req(url).execute((Callback)new Callback<Net.Response>(){

            public void onSuccess(Net.Response rsp) {
                image.setImage(UIImage.create((NSData)new NSData(rsp.payload())), Scale.ONE);
            }

            public void onFailure(Throwable cause) {
                image.setError(cause);
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        return this.createSound(path, false);
    }

    public Sound getMusic(String path) {
        return this.createSound(path, true);
    }

    public String getTextSync(String path) throws Exception {
        this.platform.log().debug("Loading text " + path);
        return new String(this.getBytesSync(path), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesSync(String path) throws Exception {
        File fullPath = this.resolvePath(path);
        this.platform.log().debug("Loading bytes " + fullPath);
        try (FileInputStream in = new FileInputStream(fullPath);){
            byte[] data = new byte[(int)fullPath.length()];
            if (in.read(data) != data.length) {
                throw new IOException("Failed to read entire file: " + fullPath);
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    protected Image createStaticImage(UIImage uiImage, Scale scale) {
        return new RoboImage((GLContext)this.platform.graphics().ctx, uiImage.getCGImage(), scale);
    }

    protected AsyncImage<UIImage> createAsyncImage(float width, float height) {
        return new RoboAsyncImage((GLContext)this.platform.graphics().ctx, width, height);
    }

    protected Image loadImage(String path, AbstractAssets.ImageReceiver<UIImage> recv) {
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.platform.graphics().ctx().scale.getScaledResources(path)) {
            File fullPath = this.resolvePath(rsrc.path);
            if (!fullPath.exists()) continue;
            UIImage img = UIImage.create((String)fullPath.toString());
            if (img != null) {
                return recv.imageLoaded((Object)img, rsrc.scale);
            }
            this.platform.log().warn("Failed to load image '" + fullPath + "'.");
            error = new Exception("Failed to load " + fullPath);
        }
        if (error == null) {
            File fullPath = this.resolvePath(path);
            this.platform.log().warn("Missing image '" + fullPath + "'.");
            error = new FileNotFoundException(fullPath.toString());
        }
        return recv.loadFailed(error);
    }

    protected File resolvePath(String path) {
        return new File(this.assetRoot, path);
    }

    private Sound createSound(String path, boolean isMusic) {
        for (String encpath : new String[]{path + ".caf", path + ".aifc", path + ".mp3"}) {
            File fullPath = this.resolvePath(encpath);
            if (!fullPath.exists()) continue;
            return this.platform.audio().createSound(fullPath, isMusic);
        }
        this.platform.log().warn("Missing sound: " + path);
        return new Sound.Error((Exception)new FileNotFoundException(path));
    }
}

