/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.File;
import org.robovm.apple.avfoundation.AVAudioPlayer;
import org.robovm.apple.avfoundation.AVAudioSession;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSURL;
import playn.core.AudioImpl;
import playn.core.Platform;
import playn.core.Sound;
import playn.robovm.CAFLoader;
import playn.robovm.OpenAL;
import playn.robovm.RoboPlatform;
import playn.robovm.RoboSoundAVAP;
import playn.robovm.RoboSoundOAL;

public class RoboAudio
extends AudioImpl {
    private final RoboPlatform platform;
    private final AVAudioSession session;
    private final long oalDevice;
    private final long oalContext;
    private final int[] sources;
    private final RoboSoundOAL[] active;
    private final int[] started;

    public RoboAudio(RoboPlatform platform, int numSources) {
        super((Platform)platform);
        this.platform = platform;
        this.session = AVAudioSession.sharedInstance();
        this.session.setActive(true, null);
        this.oalDevice = OpenAL.alcOpenDevice(null);
        if (this.oalDevice != 0L) {
            this.oalContext = OpenAL.alcCreateContext(this.oalDevice, null);
            OpenAL.alcMakeContextCurrent(this.oalContext);
        } else {
            platform.log().warn("Unable to open OpenAL device. Disabling OAL sound.");
            this.oalContext = 0L;
        }
        this.sources = new int[numSources];
        OpenAL.alGenSources(numSources, this.sources);
        this.active = new RoboSoundOAL[this.sources.length];
        this.started = new int[this.sources.length];
    }

    public Sound createSound(File path, boolean isMusic) {
        return isMusic || !path.getName().endsWith(".caf") ? this.createAVAP(new NSURL(path)) : this.createOAL(path);
    }

    Sound createAVAP(final NSURL url) {
        final RoboSoundAVAP sound = new RoboSoundAVAP();
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                NSError.NSErrorPtr error = new NSError.NSErrorPtr();
                AVAudioPlayer player = new AVAudioPlayer(url, error);
                if (error.get() == null) {
                    RoboAudio.this.dispatchLoaded(sound, player);
                } else {
                    String errstr = ((NSError)error.get()).toString();
                    RoboAudio.this.platform.log().warn("Error loading sound [" + url + ", " + errstr + "]");
                    RoboAudio.this.dispatchLoadError(sound, new Exception(errstr));
                }
            }
        });
        return sound;
    }

    Sound createOAL(final File assetPath) {
        final RoboSoundOAL sound = new RoboSoundOAL(this);
        this.platform.invokeAsync(new Runnable(){

            @Override
            public void run() {
                int bufferId = 0;
                try {
                    bufferId = OpenAL.alGenBuffer();
                    CAFLoader.load(assetPath, bufferId);
                    RoboAudio.this.dispatchLoaded(sound, bufferId);
                }
                catch (Throwable t) {
                    if (bufferId != 0) {
                        OpenAL.alDeleteBuffer(bufferId);
                    }
                    RoboAudio.this.dispatchLoadError(sound, t);
                }
            }
        });
        return sound;
    }

    boolean isPlaying(int sourceIdx, RoboSoundOAL sound) {
        if (this.active[sourceIdx] != sound) {
            return false;
        }
        int[] result = new int[1];
        OpenAL.alGetSourcei(this.sources[sourceIdx], 4112, result);
        return result[0] == 4114;
    }

    int play(RoboSoundOAL sound, float volume, boolean looping) {
        int sourceIdx = -1;
        int eldestIdx = 0;
        for (int ii = 0; ii < this.sources.length; ++ii) {
            if (!this.isPlaying(ii, this.active[ii])) {
                sourceIdx = ii;
                break;
            }
            if (this.started[ii] >= this.started[eldestIdx]) continue;
            eldestIdx = ii;
        }
        if (sourceIdx < 0) {
            this.stop(eldestIdx, this.active[eldestIdx]);
            sourceIdx = eldestIdx;
        }
        int sourceId = this.sources[sourceIdx];
        OpenAL.alSourcei(sourceId, 4105, sound.bufferId());
        OpenAL.alSourcef(sourceId, 4106, volume);
        OpenAL.alSourcei(sourceId, 4103, looping ? 1 : 0);
        OpenAL.alSourcePlay(sourceId);
        this.active[sourceIdx] = sound;
        this.started[sourceIdx] = this.platform.tick();
        return sourceIdx;
    }

    void stop(int sourceIdx, RoboSoundOAL sound) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourceStop(this.sources[sourceIdx]);
        }
    }

    void setLooping(int sourceIdx, RoboSoundOAL sound, boolean looping) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourcei(this.sources[sourceIdx], 4103, looping ? 1 : 0);
        }
    }

    void setVolume(int sourceIdx, RoboSoundOAL sound, float volume) {
        if (this.active[sourceIdx] == sound) {
            OpenAL.alSourcef(this.sources[sourceIdx], 4106, volume);
        }
    }

    void terminate() {
    }
}

