/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGGradient;
import org.robovm.apple.coregraphics.CGGradientDrawingOptions;
import org.robovm.apple.coregraphics.CGPoint;
import playn.core.Gradient;
import playn.robovm.RoboGraphics;

public abstract class RoboGradient
implements Gradient {
    private static final CGGradientDrawingOptions gdOptions = CGGradientDrawingOptions.BeforeStartLocation;
    final CGGradient cgGradient;

    abstract void fill(CGBitmapContext var1);

    protected RoboGradient(int[] colors, float[] positions) {
        float[] comps = new float[colors.length * 4];
        int cc = 0;
        for (int color : colors) {
            comps[cc++] = (float)(color >> 16 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 8 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 0 & 0xFF) / 255.0f;
            comps[cc++] = (float)(color >> 24 & 0xFF) / 255.0f;
        }
        this.cgGradient = CGGradient.create((CGColorSpace)RoboGraphics.colorSpace, (float[])comps, (float[])positions, (long)0L);
    }

    protected void finalize() {
        this.cgGradient.dispose();
    }

    public static class Radial
    extends RoboGradient {
        final CGPoint center;
        final float r;

        public Radial(float x, float y, float r, int[] colors, float[] positions) {
            super(colors, positions);
            this.center = new CGPoint((double)x, (double)y);
            this.r = r;
        }

        @Override
        void fill(CGBitmapContext bctx) {
            bctx.drawRadialGradient(this.cgGradient, this.center, 0.0, this.center, (double)this.r, gdOptions);
        }
    }

    public static class Linear
    extends RoboGradient {
        final CGPoint start;
        final CGPoint end;

        public Linear(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
            super(colors, positions);
            this.start = new CGPoint((double)x0, (double)y0);
            this.end = new CGPoint((double)x1, (double)y1);
        }

        @Override
        void fill(CGBitmapContext bctx) {
            bctx.drawLinearGradient(this.cgGradient, this.start, this.end, gdOptions);
        }
    }
}

