/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSHTTPURLResponse;
import org.robovm.apple.foundation.NSMutableData;
import org.robovm.apple.foundation.NSMutableURLRequest;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLConnection;
import org.robovm.apple.foundation.NSURLConnectionDataDelegateAdapter;
import org.robovm.apple.foundation.NSURLConnectionDelegate;
import org.robovm.apple.foundation.NSURLRequest;
import org.robovm.apple.foundation.NSURLResponse;
import playn.core.AbstractPlatform;
import playn.core.Net;
import playn.core.NetImpl;
import playn.core.util.Callback;
import playn.robovm.RoboPlatform;

public class RoboNet
extends NetImpl {
    public RoboNet(RoboPlatform platform) {
        super((AbstractPlatform)platform);
    }

    protected void execute(NetImpl.BuilderImpl req, Callback<Net.Response> callback) {
        NSMutableURLRequest mreq = new NSMutableURLRequest();
        mreq.setURL(new NSURL(req.url));
        for (NetImpl.Header header : req.headers) {
            mreq.setValue$forHTTPHeaderField$(header.value, header.name);
        }
        mreq.setHTTPMethod(req.method());
        if (req.isPost()) {
            mreq.setValue$forHTTPHeaderField$(req.contentType(), "Content-type");
            if (req.payloadString != null) {
                try {
                    mreq.setHTTPBody(new NSData(req.payloadString.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
            } else {
                mreq.setHTTPBody(new NSData(req.payloadBytes));
            }
        }
        this.sendRequest((NSURLRequest)mreq, callback);
    }

    protected void sendRequest(NSURLRequest req, final Callback<Net.Response> callback) {
        new NSURLConnection(req, (NSURLConnectionDelegate)new NSURLConnectionDataDelegateAdapter(){
            private NSMutableData data;
            private int rspCode = -1;
            private NSDictionary<NSString, ?> headers;

            public void connection$didReceiveResponse$(NSURLConnection conn, NSURLResponse rsp) {
                this.data = new NSMutableData();
                if (rsp instanceof NSHTTPURLResponse) {
                    NSHTTPURLResponse hrsp = (NSHTTPURLResponse)rsp;
                    this.rspCode = (int)hrsp.getStatusCode();
                    this.headers = hrsp.getAllHeaderFields();
                }
            }

            public void connection$didReceiveData$(NSURLConnection conn, NSData data) {
                this.data.append(data);
            }

            public void didFail(NSURLConnection conn, NSError error) {
                String errmsg = error.getLocalizedDescription();
                Object exn = this.rspCode > 0 ? new Net.HttpException(this.rspCode, errmsg) : new Exception(errmsg);
                RoboNet.this.platform.notifyFailure(callback, (Throwable)exn);
            }

            public void connectionDidFinishLoading$(NSURLConnection conn) {
                RoboNet.this.platform.notifySuccess(callback, (Object)new NetImpl.ResponseImpl(this.rspCode){

                    protected Map<String, List<String>> extractHeaders() {
                        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
                        for (Map.Entry entry : headers.entrySet()) {
                            headerMap.put(((NSString)entry.getKey()).toString(), Collections.singletonList(entry.getValue().toString()));
                        }
                        return headerMap;
                    }

                    public String payloadString() {
                        try {
                            return new String(data.getBytes(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new RuntimeException(uee);
                        }
                    }

                    public byte[] payload() {
                        return data.getBytes();
                    }
                });
            }
        }, true);
    }
}

